/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OpenSSLAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSSLAnalyzer.class);
    private static final int HEXADECIMAL = 16;
    private static final String OPENSSLV_H = "opensslv.h";
    private static final FileFilter OPENSSLV_FILTER = FileFilterBuilder.newInstance().addFilenames("opensslv.h").build();
    private static final Pattern VERSION_PATTERN = Pattern.compile("define\\s+OPENSSL_VERSION_NUMBER\\s+0x([0-9a-zA-Z]{8})L", 34);
    private static final int MAJOR_OFFSET = 28;
    private static final long MINOR_MASK = 0xFF00000L;
    private static final int MINOR_OFFSET = 20;
    private static final long FIX_MASK = 1044480L;
    private static final int FIX_OFFSET = 12;
    private static final long PATCH_MASK = 4080L;
    private static final int PATCH_OFFSET = 4;
    private static final int NUM_LETTERS = 26;
    private static final int STATUS_MASK = 15;

    protected static String getOpenSSLVersion(long openSSLVersionConstant) {
        long major = openSSLVersionConstant >>> 28;
        long minor = (openSSLVersionConstant & 0xFF00000L) >>> 20;
        long fix = (openSSLVersionConstant & 0xFF000L) >>> 12;
        long patchLevel = (openSSLVersionConstant & 0xFF0L) >>> 4;
        String patch = 0L == patchLevel || patchLevel > 26L ? "" : String.valueOf((char)(patchLevel + 97L - 1L));
        int statusCode = (int)(openSSLVersionConstant & 0xFL);
        String status = 15 == statusCode ? "" : (0 == statusCode ? "-dev" : "-beta" + statusCode);
        return String.format("%d.%d.%d%s%s", major, minor, fix, patch, status);
    }

    @Override
    public String getName() {
        return "OpenSSL Source Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }

    @Override
    protected FileFilter getFileFilter() {
        return OPENSSLV_FILTER;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.openssl.enabled";
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        Matcher matcher;
        File file = dependency.getActualFile();
        String parentName = file.getParentFile().getName();
        boolean found = false;
        String contents = this.getFileContents(file);
        if (!contents.isEmpty() && (matcher = VERSION_PATTERN.matcher(contents)).find()) {
            found = true;
            String version = OpenSSLAnalyzer.getOpenSSLVersion(Long.parseLong(matcher.group(1), 16));
            dependency.addEvidence(EvidenceType.VERSION, OPENSSLV_H, "Version Constant", version, Confidence.HIGH);
            try {
                PackageURL purl = PackageURLBuilder.aPackageURL().withType("generic").withName("openssl").withVersion(version).build();
                dependency.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
            }
            catch (MalformedPackageURLException ex) {
                LOGGER.debug("Unable to build package url for openssl", (Throwable)ex);
                GenericIdentifier id = new GenericIdentifier("generic:openssl@" + version, Confidence.HIGHEST);
                dependency.addSoftwareIdentifier(id);
            }
        }
        if (found) {
            dependency.setDisplayFileName(parentName + File.separatorChar + OPENSSLV_H);
            dependency.addEvidence(EvidenceType.VENDOR, OPENSSLV_H, "Vendor", "OpenSSL", Confidence.HIGHEST);
            dependency.addEvidence(EvidenceType.PRODUCT, OPENSSLV_H, "Product", "OpenSSL", Confidence.HIGHEST);
        } else {
            engine.removeDependency(dependency);
        }
    }

    private String getFileContents(File actualFile) throws AnalysisException {
        try {
            return FileUtils.readFileToString((File)actualFile, (Charset)Charset.defaultCharset()).trim();
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
    }
}

