/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.utils.DependencyVersion;

@ThreadSafe
public final class DependencyVersionUtil {
    private static final Pattern RX_VERSION = Pattern.compile("\\d+(\\.\\d+){1,6}([._-]?(snapshot|release|final|alpha|beta|rc$|[a-zA-Z]{1,3}[_-]?\\d{1,8}|[a-z]\\b|\\d{1,8}\\b))?", 2);
    private static final Pattern RX_SINGLE_VERSION = Pattern.compile("\\d+(\\.\\d+){0,6}([._-]?(snapshot|release|final|alpha|beta|rc$|[a-zA-Z]{1,3}[_-]?\\d{1,8}))?");
    private static final Pattern RX_PRE_VERSION = Pattern.compile("^(.+)[_-](\\d+\\.\\d{1,6})+");

    private DependencyVersionUtil() {
    }

    public static DependencyVersion parseVersion(String text) {
        return DependencyVersionUtil.parseVersion(text, false);
    }

    public static DependencyVersion parseVersion(String text, boolean firstMatchOnly) {
        if (text == null) {
            return null;
        }
        if ("-".equals(text)) {
            DependencyVersion dv = new DependencyVersion();
            ArrayList<String> list = new ArrayList<String>();
            list.add(text);
            dv.setVersionParts(list);
            return dv;
        }
        String version = null;
        Matcher matcher = RX_VERSION.matcher(text);
        if (matcher.find()) {
            version = matcher.group();
        }
        if (!firstMatchOnly && matcher.find()) {
            return null;
        }
        if (version == null) {
            matcher = RX_SINGLE_VERSION.matcher(text);
            if (!matcher.find()) {
                return null;
            }
            version = matcher.group();
            if (matcher.find()) {
                return null;
            }
        }
        if (version != null && version.endsWith("-py2") && version.length() > 4) {
            version = version.substring(0, version.length() - 4);
        }
        return new DependencyVersion(version);
    }

    public static String parsePreVersion(String text) {
        if (DependencyVersionUtil.parseVersion(text) == null) {
            return text;
        }
        Matcher matcher = RX_PRE_VERSION.matcher(text);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return text;
    }
}

