/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.reporting;

import org.owasp.dependencycheck.dependency.naming.CpeIdentifier;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.utils.SeverityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.Cpe;
import us.springett.parsers.cpe.exceptions.CpeEncodingException;
import us.springett.parsers.cpe.util.Convert;
import us.springett.parsers.cpe.values.Part;

public class ReportTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportTool.class);

    public String identifierToSuppressionId(Identifier id) {
        if (id instanceof PurlIdentifier) {
            PurlIdentifier purl = (PurlIdentifier)id;
            return purl.toString();
        }
        if (id instanceof CpeIdentifier) {
            try {
                CpeIdentifier cpeId = (CpeIdentifier)id;
                Cpe cpe = cpeId.getCpe();
                return String.format("cpe:/%s:%s:%s", Convert.wellFormedToCpeUri((Part)cpe.getPart()), Convert.wellFormedToCpeUri((String)cpe.getWellFormedVendor()), Convert.wellFormedToCpeUri((String)cpe.getWellFormedProduct()));
            }
            catch (CpeEncodingException ex) {
                LOGGER.debug("Unable to convert to cpe URI", (Throwable)ex);
            }
        } else if (id instanceof GenericIdentifier) {
            return id.getValue();
        }
        return null;
    }

    public float estimateSeverity(String severity) {
        return SeverityUtil.estimateCvssV2(severity);
    }
}

