/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractNpmAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.SearchException;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.data.nodeaudit.Advisory;
import org.owasp.dependencycheck.data.nodeaudit.NpmPayloadBuilder;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.exceptions.CpeValidationException;

@ThreadSafe
public class NodeAuditAnalyzer
extends AbstractNpmAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeAuditAnalyzer.class);
    public static final String DEFAULT_URL = "https://registry.npmjs.org/-/npm/v1/security/audits";
    public static final String DEPENDENCY_ECOSYSTEM = "nodejs";
    public static final String PACKAGE_LOCK_JSON = "package-lock.json";
    public static final String SHRINKWRAP_JSON = "npm-shrinkwrap.json";
    private static final FileFilter PACKAGE_JSON_FILTER = FileFilterBuilder.newInstance().addFilenames("package-lock.json", "npm-shrinkwrap.json").build();

    @Override
    protected FileFilter getFileFilter() {
        return PACKAGE_JSON_FILTER;
    }

    @Override
    public String getName() {
        return "Node Audit Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINDING_ANALYSIS;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.node.audit.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        if (dependency.getDisplayFileName().equals(dependency.getFileName())) {
            engine.removeDependency(dependency);
        }
        File packageLock = dependency.getActualFile();
        File shrinkwrap = new File(packageLock.getParentFile(), SHRINKWRAP_JSON);
        if (PACKAGE_LOCK_JSON.equals(dependency.getFileName()) && shrinkwrap.isFile()) {
            LOGGER.debug("Skipping {} because shrinkwrap lock file exists", (Object)dependency.getFilePath());
            return;
        }
        if (!packageLock.isFile() || packageLock.length() == 0L || !NodeAuditAnalyzer.shouldProcess(packageLock)) {
            return;
        }
        File packageJson = new File(packageLock.getParentFile(), "package.json");
        HashSetValuedHashMap dependencyMap = new HashSetValuedHashMap();
        List<Advisory> advisories = packageJson.isFile() ? this.analyzePackage(packageLock, packageJson, dependency, (MultiValuedMap<String, String>)dependencyMap) : this.legacyAnalysis(packageLock, dependency, (MultiValuedMap<String, String>)dependencyMap);
        try {
            this.processResults(advisories, engine, dependency, (MultiValuedMap<String, String>)dependencyMap);
        }
        catch (CpeValidationException ex) {
            throw new UnexpectedAnalysisException(ex);
        }
    }

    private List<Advisory> analyzePackage(File lockFile, File packageFile, Dependency dependency, MultiValuedMap<String, String> dependencyMap) throws AnalysisException {
        try {
            JsonReader packageReader = Json.createReader((InputStream)FileUtils.openInputStream((File)packageFile));
            JsonReader lockReader = Json.createReader((InputStream)FileUtils.openInputStream((File)lockFile));
            JsonObject lockJson = lockReader.readObject();
            JsonObject packageJson = packageReader.readObject();
            JsonObject payload = NpmPayloadBuilder.build(lockJson, packageJson, dependencyMap, this.getSettings().getBoolean("analyzer.node.audit.skipdev", false));
            return this.getSearcher().submitPackage(payload);
        }
        catch (URLConnectionFailureException e) {
            this.setEnabled(false);
            throw new AnalysisException("Failed to connect to the NPM Audit API (NodeAuditAnalyzer); the analyzer is being disabled and may result in false negatives.", e);
        }
        catch (IOException e) {
            LOGGER.debug("Error reading dependency or connecting to NPM Audit API", (Throwable)e);
            this.setEnabled(false);
            throw new AnalysisException("Failed to read results from the NPM Audit API (NodeAuditAnalyzer); the analyzer is being disabled and may result in false negatives.", e);
        }
        catch (JsonException e) {
            throw new AnalysisException(String.format("Failed to parse %s file from the NPM Audit API (NodeAuditAnalyzer).", lockFile.getPath()), e);
        }
        catch (SearchException e) {
            File yarnCheck = new File(lockFile.getParentFile(), "yarn.lock");
            if (yarnCheck.exists()) {
                String msg = "NodeAuditAnalyzer failed on " + dependency.getActualFilePath() + " - yarn.lock was found; if package-lock.json was generated using synp, it may not be in the correct format.";
                LOGGER.error(msg);
                throw new AnalysisException(msg, e);
            }
            LOGGER.error("NodeAuditAnalyzer failed on {}", (Object)dependency.getActualFilePath());
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Advisory> legacyAnalysis(File file, Dependency dependency, MultiValuedMap<String, String> dependencyMap) throws AnalysisException {
        try (JsonReader jsonReader = Json.createReader((InputStream)FileUtils.openInputStream((File)file));){
            JsonObject packageJson = jsonReader.readObject();
            String projectName = packageJson.getString("name", "");
            String projectVersion = packageJson.getString("version", "");
            if (!projectName.isEmpty()) {
                dependency.setName(projectName);
            }
            if (!projectVersion.isEmpty()) {
                dependency.setVersion(projectVersion);
            }
            JsonObject payload = NpmPayloadBuilder.build(packageJson, dependencyMap);
            List<Advisory> list = this.getSearcher().submitPackage(payload);
            return list;
        }
        catch (URLConnectionFailureException e) {
            this.setEnabled(false);
            throw new AnalysisException("Failed to connect to the NPM Audit API (NodeAuditAnalyzer); the analyzer is being disabled and may result in false negatives.", e);
        }
        catch (IOException e) {
            LOGGER.debug("Error reading dependency or connecting to NPM Audit API", (Throwable)e);
            this.setEnabled(false);
            throw new AnalysisException("Failed to read results from the NPM Audit API (NodeAuditAnalyzer); the analyzer is being disabled and may result in false negatives.", e);
        }
        catch (JsonException e) {
            throw new AnalysisException(String.format("Failed to parse %s file from the NPM Audit API (NodeAuditAnalyzer).", file.getPath()), e);
        }
        catch (SearchException ex) {
            LOGGER.error("NodeAuditAnalyzer failed on {}", (Object)dependency.getActualFilePath());
            throw ex;
        }
    }
}

