/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.util.Set;
import org.owasp.dependencycheck.analyzer.AbstractDependencyComparingAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.Evidence;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyMergingAnalyzer
extends AbstractDependencyComparingAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyMergingAnalyzer.class);
    private static final String ANALYZER_NAME = "Dependency Merging Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.POST_INFORMATION_COLLECTION;

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.dependencymerging.enabled";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean evaluateDependencies(Dependency dependency, Dependency nextDependency, Set<Dependency> dependenciesToRemove) {
        Dependency main = this.getMainGemspecDependency(dependency, nextDependency);
        if (main != null) {
            if (main == dependency) {
                DependencyMergingAnalyzer.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
                return false;
            }
            DependencyMergingAnalyzer.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
            return true;
        }
        main = this.getMainSwiftDependency(dependency, nextDependency);
        if (main != null) {
            if (main == dependency) {
                DependencyMergingAnalyzer.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
                return false;
            }
            DependencyMergingAnalyzer.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
            return true;
        }
        main = this.getMainAndroidDependency(dependency, nextDependency);
        if (main != null) {
            if (main == dependency) {
                DependencyMergingAnalyzer.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
                return false;
            }
            DependencyMergingAnalyzer.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
            return true;
        }
        main = this.getMainDotnetDependency(dependency, nextDependency);
        if (main != null) {
            if (main == dependency) {
                DependencyMergingAnalyzer.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
                return false;
            }
            DependencyMergingAnalyzer.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
            return true;
        }
        main = this.getMainVirtualDependency(dependency, nextDependency);
        if (main == null) return false;
        if (main == dependency) {
            DependencyMergingAnalyzer.mergeDependencies(dependency, nextDependency, dependenciesToRemove);
            return false;
        }
        DependencyMergingAnalyzer.mergeDependencies(nextDependency, dependency, dependenciesToRemove);
        return true;
    }

    public static void mergeDependencies(Dependency dependency, Dependency relatedDependency, Set<Dependency> dependenciesToRemove) {
        LOGGER.debug("Merging '{}' into '{}'", (Object)relatedDependency.getFilePath(), (Object)dependency.getFilePath());
        dependency.addRelatedDependency(relatedDependency);
        relatedDependency.getEvidence(EvidenceType.VENDOR).forEach(e -> dependency.addEvidence(EvidenceType.VENDOR, (Evidence)e));
        relatedDependency.getEvidence(EvidenceType.PRODUCT).forEach(e -> dependency.addEvidence(EvidenceType.PRODUCT, (Evidence)e));
        relatedDependency.getEvidence(EvidenceType.VERSION).forEach(e -> dependency.addEvidence(EvidenceType.VERSION, (Evidence)e));
        relatedDependency.getRelatedDependencies().stream().forEach(dependency::addRelatedDependency);
        relatedDependency.clearRelatedDependencies();
        dependency.addAllProjectReferences(relatedDependency.getProjectReferences());
        if (dependenciesToRemove != null) {
            dependenciesToRemove.add(relatedDependency);
        }
    }

    protected boolean isSameRubyGem(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency2 == null || !dependency1.getFileName().endsWith(".gemspec") || !dependency2.getFileName().endsWith(".gemspec") || dependency1.getPackagePath() == null || dependency2.getPackagePath() == null) {
            return false;
        }
        return dependency1.getPackagePath().equalsIgnoreCase(dependency2.getPackagePath());
    }

    protected Dependency getMainGemspecDependency(Dependency dependency1, Dependency dependency2) {
        if (dependency1 != null && dependency2 != null && "ruby".equals(dependency1.getEcosystem()) && "ruby".equals(dependency2.getEcosystem()) && this.isSameRubyGem(dependency1, dependency2)) {
            File lFile = dependency1.getActualFile();
            File left = lFile.getParentFile();
            if (left != null && left.getName().equalsIgnoreCase("specifications")) {
                return dependency1;
            }
            return dependency2;
        }
        return null;
    }

    protected boolean isSameSwiftPackage(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency2 == null || !dependency1.getFileName().endsWith(".podspec") && !dependency1.getFileName().equals("Package.swift") || !dependency2.getFileName().endsWith(".podspec") && !dependency2.getFileName().equals("Package.swift") || dependency1.getPackagePath() == null || dependency2.getPackagePath() == null) {
            return false;
        }
        return dependency1.getPackagePath().equalsIgnoreCase(dependency2.getPackagePath());
    }

    protected Dependency getMainSwiftDependency(Dependency dependency1, Dependency dependency2) {
        if (dependency1 != null && dependency2 != null && "ios".equals(dependency1.getEcosystem()) && "ios".equals(dependency2.getEcosystem()) && this.isSameSwiftPackage(dependency1, dependency2)) {
            if (dependency1.getFileName().endsWith(".podspec")) {
                return dependency1;
            }
            return dependency2;
        }
        return null;
    }

    protected Dependency getMainAndroidDependency(Dependency dependency1, Dependency dependency2) {
        if (!dependency1.isVirtual() && !dependency2.isVirtual() && "java".equals(dependency1.getEcosystem()) && "java".equals(dependency2.getEcosystem())) {
            String name1 = dependency1.getActualFile().getName();
            String name2 = dependency2.getActualFile().getName();
            if ("classes.jar".equals(name2) && "aar".equals(FileUtils.getFileExtension((String)name1)) && dependency2.getFileName().contains(name1)) {
                return dependency1;
            }
            if ("classes.jar".equals(name1) && "aar".equals(FileUtils.getFileExtension((String)name2)) && dependency1.getFileName().contains(name2)) {
                return dependency2;
            }
        }
        return null;
    }

    protected Dependency getMainDotnetDependency(Dependency dependency1, Dependency dependency2) {
        if (dependency1.getName() != null && dependency1.getVersion() != null && dependency2.getName() != null && dependency2.getVersion() != null && "dotnet".equals(dependency1.getEcosystem()) && "dotnet".equals(dependency2.getEcosystem()) && dependency1.getName().equals(dependency2.getName()) && dependency1.getVersion().equals(dependency2.getVersion())) {
            if (dependency1.isVirtual()) {
                return dependency2;
            }
            return dependency1;
        }
        return null;
    }

    protected Dependency getMainVirtualDependency(Dependency dependency1, Dependency dependency2) {
        if (dependency1.isVirtual() && dependency2.isVirtual() && dependency1.getName() != null && dependency2.getName() != null && dependency1.getVersion() != null && dependency2.getVersion() != null && dependency1.getActualFilePath() != null && dependency2.getActualFilePath() != null && dependency1.getName().equals(dependency2.getName()) && dependency1.getVersion().equals(dependency2.getVersion()) && dependency1.getActualFilePath().equals(dependency2.getActualFilePath())) {
            return dependency1;
        }
        return null;
    }
}

