/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.NotThreadSafe;
import org.jetbrains.annotations.NotNull;

@NotThreadSafe
public abstract class Filter<T> {
    public abstract boolean passes(T var1);

    public Iterator<T> filter(Iterator<T> iterator) {
        return new FilterIterator(iterator);
    }

    public Iterable<T> filter(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return Filter.this.filter(iterable.iterator());
            }
        };
    }

    private class FilterIterator
    implements Iterator<T> {
        private final Iterator<T> iterator;
        private T next;

        private FilterIterator(Iterator<T> iterator) {
            this.iterator = iterator;
            this.toNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object returnValue = this.next;
            this.toNext();
            return returnValue;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void toNext() {
            this.next = null;
            while (this.iterator.hasNext()) {
                Object item = this.iterator.next();
                if (item == null || !Filter.this.passes(item)) continue;
                this.next = item;
                break;
            }
        }
    }
}

