/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nodeaudit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonObject;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.jcs.access.exception.CacheException;
import org.json.JSONObject;
import org.owasp.dependencycheck.analyzer.exception.SearchException;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.data.cache.DataCache;
import org.owasp.dependencycheck.data.cache.DataCacheFactory;
import org.owasp.dependencycheck.data.nodeaudit.Advisory;
import org.owasp.dependencycheck.data.nodeaudit.NpmAuditParser;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class NodeAuditSearch {
    private final URL nodeAuditUrl;
    private final boolean useProxy;
    private final Settings settings;
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeAuditSearch.class);
    private DataCache<List<Advisory>> cache;

    public NodeAuditSearch(Settings settings) throws MalformedURLException {
        String searchUrl = settings.getString("analyzer.node.audit.url", "https://registry.npmjs.org/-/npm/v1/security/audits");
        LOGGER.debug("Node Audit Search URL: {}", (Object)searchUrl);
        this.nodeAuditUrl = new URL(searchUrl);
        this.settings = settings;
        if (null != settings.getString("proxy.server")) {
            this.useProxy = true;
            LOGGER.debug("Using proxy");
        } else {
            this.useProxy = false;
            LOGGER.debug("Not using proxy");
        }
        if (settings.getBoolean("analyzer.node.audit.use.cache", true)) {
            try {
                DataCacheFactory factory = new DataCacheFactory(settings);
                this.cache = factory.getNodeAuditCache();
            }
            catch (CacheException ex) {
                settings.setBoolean("analyzer.node.audit.use.cache", false);
                LOGGER.debug("Error creating cache, disabling caching", (Throwable)ex);
            }
        }
    }

    public List<Advisory> submitPackage(JsonObject packageJson) throws SearchException, IOException {
        List<Advisory> cached;
        String key = null;
        if (this.cache != null && (cached = this.cache.get(key = Checksum.getSHA256Checksum((String)packageJson.toString()))) != null) {
            LOGGER.debug("cache hit for node audit: " + key);
            return cached;
        }
        return this.submitPackage(packageJson, key, 0);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    private List<Advisory> submitPackage(JsonObject packageJson, String key, int count) throws SearchException, IOException {
        try {
            if (NodeAuditSearch.LOGGER.isDebugEnabled()) {
                NodeAuditSearch.LOGGER.debug("----------------------------------------");
                NodeAuditSearch.LOGGER.debug("Node Audit Payload:");
                NodeAuditSearch.LOGGER.debug(packageJson.toString());
                NodeAuditSearch.LOGGER.debug("----------------------------------------");
                NodeAuditSearch.LOGGER.debug("----------------------------------------");
            }
            packageDatabytes = packageJson.toString().getBytes(StandardCharsets.UTF_8);
            factory = new URLConnectionFactory(this.settings);
            conn = factory.createHttpURLConnection(this.nodeAuditUrl, this.useProxy);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("user-agent", "npm/6.1.0 node/v10.5.0 linux x64");
            conn.setRequestProperty("npm-in-ci", "false");
            conn.setRequestProperty("npm-scope", "");
            conn.setRequestProperty("npm-session", this.generateRandomSession());
            conn.setRequestProperty("content-type", "application/json");
            conn.setRequestProperty("Content-Length", Integer.toString(packageDatabytes.length));
            conn.connect();
            os = new BufferedOutputStream(conn.getOutputStream());
            try {
                os.write(packageDatabytes);
                os.flush();
            }
            finally {
                os.close();
            }
            switch (conn.getResponseCode()) {
                case 200: {
                    try {
                        in = new BufferedInputStream(conn.getInputStream());
                        try {
                            jsonReader = Json.createReader((InputStream)in);
                            try {
                                jsonResponse = new JSONObject(jsonReader.readObject().toString());
                                parser = new NpmAuditParser();
                                advisories = parser.parse(jsonResponse);
                                if (this.cache != null) {
                                    this.cache.put(key, advisories);
                                }
                                var12_23 = advisories;
                                if (jsonReader == null) ** GOTO lbl56
                            }
                            catch (Throwable var9_18) {
                                if (jsonReader != null) {
                                    try {
                                        jsonReader.close();
                                    }
                                    catch (Throwable var10_21) {
                                        var9_18.addSuppressed(var10_21);
                                    }
                                }
                                throw var9_18;
                            }
                            jsonReader.close();
lbl56:
                            // 2 sources

                            return var12_23;
                        }
                        finally {
                            in.close();
                        }
                    }
                    catch (Exception ex) {
                        NodeAuditSearch.LOGGER.debug("Error connecting to Node Audit API. Error: {}", (Object)ex.getMessage());
                        throw new SearchException("Could not connect to Node Audit API: " + ex.getMessage(), ex);
                    }
                }
                case 503: {
                    NodeAuditSearch.LOGGER.debug("Node Audit API returned `{} {}` - retrying request.", (Object)conn.getResponseCode(), (Object)conn.getResponseMessage());
                    if (count < 5) {
                        next = count + 1;
                        try {
                            Thread.sleep(1500L * (long)next);
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                            throw new UnexpectedAnalysisException(ex);
                        }
                        return this.submitPackage(packageJson, key, next);
                    }
                    throw new SearchException("Could not perform Node Audit analysis - service returned a 503.");
                }
                case 400: {
                    NodeAuditSearch.LOGGER.debug("Invalid payload submitted to Node Audit API. Received response code: {} {}", (Object)conn.getResponseCode(), (Object)conn.getResponseMessage());
                    throw new SearchException("Could not perform Node Audit analysis. Invalid payload submitted to Node Audit API.");
                }
            }
            NodeAuditSearch.LOGGER.debug("Could not connect to Node Audit API. Received response code: {} {}", (Object)conn.getResponseCode(), (Object)conn.getResponseMessage());
            throw new IOException("Could not connect to Node Audit API");
        }
        catch (IOException ex) {
            if (ex instanceof SSLHandshakeException && ex.getMessage().contains("unable to find valid certification path to requested target")) {
                msg = String.format("Unable to connect to '%s' - the Java trust store does not contain a trusted root for the cert.  Please see https://github.com/jeremylong/InstallCert for one method of updating the trusted certificates.", new Object[]{this.nodeAuditUrl});
                throw new URLConnectionFailureException(msg, (Throwable)ex);
            }
            throw ex;
        }
    }

    private String generateRandomSession() {
        int length = 16;
        SecureRandom r = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        while (sb.length() < 16) {
            sb.append(Integer.toHexString(r.nextInt()));
        }
        return sb.toString().substring(0, 16);
    }
}

