/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.reporting;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.text.WordUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.data.nvdcve.DatabaseProperties;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.exception.ExceptionCollection;
import org.owasp.dependencycheck.exception.ReportException;
import org.owasp.dependencycheck.reporting.EscapeTool;
import org.owasp.dependencycheck.reporting.ReportTool;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@NotThreadSafe
public class ReportGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportGenerator.class);
    private final VelocityEngine velocityEngine;
    private final Context context;
    private final Settings settings;

    @Deprecated
    public ReportGenerator(String applicationName, List<Dependency> dependencies, List<Analyzer> analyzers, DatabaseProperties properties, Settings settings) {
        this(applicationName, dependencies, analyzers, properties, settings, null);
    }

    public ReportGenerator(String applicationName, List<Dependency> dependencies, List<Analyzer> analyzers, DatabaseProperties properties, Settings settings, ExceptionCollection exceptions) {
        this(applicationName, null, null, null, dependencies, analyzers, properties, settings, exceptions);
    }

    @Deprecated
    public ReportGenerator(String applicationName, String groupID, String artifactID, String version, List<Dependency> dependencies, List<Analyzer> analyzers, DatabaseProperties properties, Settings settings) {
        this(applicationName, groupID, artifactID, version, dependencies, analyzers, properties, settings, null);
    }

    public ReportGenerator(String applicationName, String groupID, String artifactID, String version, List<Dependency> dependencies, List<Analyzer> analyzers, DatabaseProperties properties, Settings settings, ExceptionCollection exceptions) {
        this.settings = settings;
        this.velocityEngine = this.createVelocityEngine();
        this.velocityEngine.init();
        this.context = this.createContext(applicationName, dependencies, analyzers, properties, groupID, artifactID, version, exceptions);
    }

    private VelocityContext createContext(String applicationName, List<Dependency> dependencies, List<Analyzer> analyzers, DatabaseProperties properties, String groupID, String artifactID, String version, ExceptionCollection exceptions) {
        ZonedDateTime dt = ZonedDateTime.now();
        String scanDate = DateTimeFormatter.RFC_1123_DATE_TIME.format(dt);
        String scanDateXML = DateTimeFormatter.ISO_INSTANT.format(dt);
        String scanDateJunit = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(dt);
        VelocityContext ctxt = new VelocityContext();
        ctxt.put("applicationName", (Object)applicationName);
        Collections.sort(dependencies, (d1, d2) -> d1.getDisplayFileName().compareTo(d2.getDisplayFileName()));
        ctxt.put("dependencies", dependencies);
        ctxt.put("analyzers", analyzers);
        ctxt.put("properties", (Object)properties);
        ctxt.put("scanDate", (Object)scanDate);
        ctxt.put("scanDateXML", (Object)scanDateXML);
        ctxt.put("scanDateJunit", (Object)scanDateJunit);
        ctxt.put("enc", (Object)new EscapeTool());
        ctxt.put("rpt", (Object)new ReportTool());
        ctxt.put("WordUtils", (Object)new WordUtils());
        ctxt.put("VENDOR", (Object)EvidenceType.VENDOR);
        ctxt.put("PRODUCT", (Object)EvidenceType.PRODUCT);
        ctxt.put("VERSION", (Object)EvidenceType.VERSION);
        ctxt.put("version", (Object)this.settings.getString("odc.application.version", "Unknown"));
        ctxt.put("settings", (Object)this.settings);
        if (version != null) {
            ctxt.put("applicationVersion", (Object)version);
        }
        if (artifactID != null) {
            ctxt.put("artifactID", (Object)artifactID);
        }
        if (groupID != null) {
            ctxt.put("groupID", (Object)groupID);
        }
        if (exceptions != null) {
            ctxt.put("exceptions", exceptions.getExceptions());
        }
        return ctxt;
    }

    private VelocityEngine createVelocityEngine() {
        return new VelocityEngine();
    }

    public void write(String outputLocation, String format) throws ReportException {
        Format reportFormat = null;
        try {
            reportFormat = Format.valueOf(format.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            LOGGER.trace("ignore this exception", (Throwable)ex);
        }
        if (reportFormat != null) {
            this.write(outputLocation, reportFormat);
        } else {
            File out = ReportGenerator.getReportFile(outputLocation, null);
            if (out.isDirectory()) {
                throw new ReportException("Unable to write non-standard VSL output to a directory, please specify a file name");
            }
            this.processTemplate(format, out);
        }
    }

    public void write(String outputLocation, Format format) throws ReportException {
        if (format == Format.ALL) {
            for (Format f : Format.values()) {
                if (f == Format.ALL) continue;
                this.write(outputLocation, f);
            }
        } else {
            File out = ReportGenerator.getReportFile(outputLocation, format);
            String templateName = format.toString().toLowerCase() + "Report";
            this.processTemplate(templateName, out);
            if (this.settings.getBoolean("odc.reports.pretty.print", false)) {
                if (format == Format.JSON) {
                    this.pretifyJson(out.getPath());
                } else if (format == Format.XML || format == Format.JUNIT) {
                    this.pretifyXml(out.getPath());
                }
            }
        }
    }

    public static File getReportFile(String outputLocation, Format format) {
        File outFile = new File(outputLocation);
        if (outFile.getParentFile() == null) {
            outFile = new File(".", outputLocation);
        }
        String pathToCheck = outputLocation.toLowerCase();
        if (format == Format.XML && !pathToCheck.endsWith(".xml")) {
            return new File(outFile, "dependency-check-report.xml");
        }
        if (format == Format.HTML && !pathToCheck.endsWith(".html") && !pathToCheck.endsWith(".htm")) {
            return new File(outFile, "dependency-check-report.html");
        }
        if (format == Format.JSON && !pathToCheck.endsWith(".json")) {
            return new File(outFile, "dependency-check-report.json");
        }
        if (format == Format.CSV && !pathToCheck.endsWith(".csv")) {
            return new File(outFile, "dependency-check-report.csv");
        }
        if (format == Format.JUNIT && !pathToCheck.endsWith(".xml")) {
            return new File(outFile, "dependency-check-junit.xml");
        }
        return outFile;
    }

    @SuppressFBWarnings(justification="try with resources will clean up the output stream", value={"OBL_UNSATISFIED_OBLIGATION"})
    protected void processTemplate(String template, File file) throws ReportException {
        this.ensureParentDirectoryExists(file);
        try (FileOutputStream output = new FileOutputStream(file);){
            this.processTemplate(template, output);
        }
        catch (IOException ex) {
            throw new ReportException(String.format("Unable to write to file: %s", file), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTemplate(String templateName, OutputStream outputStream) throws ReportException {
        InputStream input = null;
        File f = new File(templateName);
        try {
            String logTag;
            if (f.isFile()) {
                try {
                    logTag = templateName;
                    input = new FileInputStream(f);
                }
                catch (FileNotFoundException ex) {
                    throw new ReportException("Unable to locate template file: " + templateName, ex);
                }
            } else {
                logTag = "templates/" + templateName + ".vsl";
                input = org.owasp.dependencycheck.utils.FileUtils.getResourceAsStream((String)logTag);
            }
            if (input == null) {
                logTag = templateName;
                input = org.owasp.dependencycheck.utils.FileUtils.getResourceAsStream((String)templateName);
            }
            if (input == null) {
                throw new ReportException("Template file doesn't exist: " + logTag);
            }
            try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
                 OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                if (!this.velocityEngine.evaluate(this.context, (Writer)writer, logTag, (Reader)reader)) {
                    throw new ReportException("Failed to convert the template into html.");
                }
                writer.flush();
            }
            catch (UnsupportedEncodingException ex) {
                throw new ReportException("Unable to generate the report using UTF-8", ex);
            }
            catch (IOException ex) {
                throw new ReportException("Unable to write the report", ex);
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("Error closing input", (Throwable)ex);
                }
            }
        }
    }

    private void ensureParentDirectoryExists(File file) throws ReportException {
        boolean created;
        if (!file.getParentFile().exists() && !(created = file.getParentFile().mkdirs())) {
            String msg = String.format("Unable to create directory '%s'.", file.getParentFile().getAbsolutePath());
            throw new ReportException(msg);
        }
    }

    private void pretifyXml(String path) throws ReportException {
        String outputPath = path + ".pretty";
        File in = new File(path);
        File out = new File(outputPath);
        try {
            TransformerFactory transformerFactory = SAXTransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            SAXSource saxs = new SAXSource(new InputSource(path));
            XMLReader saxReader = XmlUtils.buildSecureSaxParser().getXMLReader();
            saxs.setXMLReader(saxReader);
            transformer.transform(saxs, new StreamResult(new OutputStreamWriter((OutputStream)new FileOutputStream(out), "utf-8")));
        }
        catch (ParserConfigurationException | TransformerConfigurationException ex) {
            LOGGER.debug("Configuration exception when pretty printing", (Throwable)ex);
            LOGGER.error("Unable to generate pretty report, caused by: {}", (Object)ex.getMessage());
        }
        catch (FileNotFoundException | UnsupportedEncodingException | TransformerException | SAXException ex) {
            LOGGER.debug("Malformed XML?", (Throwable)ex);
            LOGGER.error("Unable to generate pretty report, caused by: {}", (Object)ex.getMessage());
        }
        if (out.isFile() && in.isFile() && in.delete()) {
            try {
                Thread.sleep(1000L);
                FileUtils.moveFile((File)out, (File)in);
            }
            catch (IOException ex) {
                LOGGER.error("Unable to generate pretty report, caused by: {}", (Object)ex.getMessage());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                LOGGER.error("Unable to generate pretty report, caused by: {}", (Object)ex.getMessage());
            }
        }
    }

    private void pretifyJson(String pathToJson) throws ReportException {
        String outputPath = pathToJson + ".pretty";
        File in = new File(pathToJson);
        File out = new File(outputPath);
        JsonFactory factory = new JsonFactory();
        try (JsonParser parser = factory.createParser((InputStream)new FileInputStream(in));
             JsonGenerator generator = factory.createGenerator((OutputStream)new FileOutputStream(out));){
            generator.useDefaultPrettyPrinter();
            while (parser.nextToken() != null) {
                generator.copyCurrentEvent(parser);
            }
        }
        catch (IOException ex) {
            LOGGER.debug("Malformed JSON?", (Throwable)ex);
            throw new ReportException("Unable to generate json report", ex);
        }
        if (out.isFile() && in.isFile() && in.delete()) {
            try {
                Thread.sleep(1000L);
                FileUtils.moveFile((File)out, (File)in);
            }
            catch (IOException ex) {
                LOGGER.error("Unable to generate pretty report, caused by: {}", (Object)ex.getMessage());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                LOGGER.error("Unable to generate pretty report, caused by: {}", (Object)ex.getMessage());
            }
        }
    }

    public static enum Format {
        ALL,
        XML,
        HTML,
        JSON,
        CSV,
        JUNIT;

    }
}

