/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.golang.GoModJsonParser;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class GolangModAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GolangModAnalyzer.class);
    public static final String DEPENDENCY_ECOSYSTEM = "golang";
    private static final String ANALYZER_NAME = "Golang Mod Analyzer";
    public static final String GO_MOD = "go.mod";
    private static final FileFilter GO_MOD_FILTER = FileFilterBuilder.newInstance().addFilenames("go.mod").build();

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.golang.mod.enabled";
    }

    @Override
    protected FileFilter getFileFilter() {
        return GO_MOD_FILTER;
    }

    private String getGo() {
        String goPath = this.getSettings().getString("analyzer.golang.path");
        if (goPath == null) {
            LOGGER.warn("Path to `go` executable not set. Trying default location. If you do want to set it, please set the `{}` property", (Object)"analyzer.golang.path");
            return "go";
        }
        File goFile = new File(goPath);
        if (goFile.isFile()) {
            return goFile.getAbsolutePath();
        }
        LOGGER.warn("Path to `go` exec executable does not exist: {}. Trying default location", (Object)goPath);
        return "go";
    }

    private Process testGoMod(File folder) throws AnalysisException {
        if (!folder.isDirectory()) {
            throw new AnalysisException(String.format("%s should have been a directory.", folder.getAbsolutePath()));
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getGo());
        args.add("mod");
        args.add("edit");
        args.add("-json");
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.directory(folder);
        try {
            LOGGER.info("Launching: {} from {}", args, (Object)folder);
            return builder.start();
        }
        catch (IOException ioe) {
            throw new AnalysisException("go initialization failure; this error can be ignored if you are not analyzing Go. Otherwise ensure that go is installed and the path to go is correctly specified", ioe);
        }
    }

    private Process launchGoMod(File folder) throws AnalysisException {
        if (!folder.isDirectory()) {
            throw new AnalysisException(String.format("%s should have been a directory.", folder.getAbsolutePath()));
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getGo());
        args.add("list");
        args.add("-json");
        args.add("-m");
        args.add("all");
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.directory(folder);
        try {
            LOGGER.info("Launching: {} from {}", args, (Object)folder);
            return builder.start();
        }
        catch (IOException ioe) {
            throw new AnalysisException("go initialization failure; this error can be ignored if you are not analyzing Go. Otherwise ensure that go is installed and the path to go is correctly specified", ioe);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @SuppressFBWarnings(justification="The fallthrough is intentional to avoid code duplication", value={"SF_SWITCH_NO_DEFAULT"})
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        this.setEnabled(false);
        try {
            process = this.testGoMod(this.getSettings().getTempDirectory());
        }
        catch (AnalysisException ae) {
            msg = String.format("Exception from go process: %s. Disabling %s", new Object[]{ae.getCause(), "Golang Mod Analyzer"});
            throw new InitializationException(msg, ae);
        }
        catch (IOException ex) {
            throw new InitializationException("Unable to create temporary file, the Go Mod Analyzer will be disabled", ex);
        }
        try {
            exitValue = process.waitFor();
        }
        catch (InterruptedException ex) {
            msg = String.format("Go mod process was interrupted. Disabling %s", new Object[]{"Golang Mod Analyzer"});
            Thread.currentThread().interrupt();
            throw new InitializationException(msg);
        }
        expectedNoModuleFoundExitValue = true;
        possiblyGoTooOldExitValue = 2;
        goExecutableNotFoundExitValue = 127;
        switch (exitValue) {
            case 1: {
                this.setEnabled(true);
                GolangModAnalyzer.LOGGER.info("{} is enabled.", (Object)"Golang Mod Analyzer");
                return;
            }
            case 127: {
                throw new InitializationException(String.format("Go executable not found. Disabling %s: %s", new Object[]{"Golang Mod Analyzer", exitValue}));
            }
            case 2: {
                try {
                    reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
                    var8_15 = null;
                    if (!reader.ready()) {
                        GolangModAnalyzer.LOGGER.warn("Go mod error stream unexpectedly not ready. Disabling {}", (Object)"Golang Mod Analyzer");
                        throw new InitializationException("Go mod error stream unexpectedly not ready.");
                    }
                    line = reader.readLine();
                    if (line == null) {
                        GolangModAnalyzer.LOGGER.warn("An error occurred calling `go` - no output could be read. Disabling {}.", (Object)"Golang Mod Analyzer");
                        throw new InitializationException("Error calling `go` - no output could be read.");
                    }
                    if (line.contains("unknown subcommand \"mod\"")) {
                        GolangModAnalyzer.LOGGER.warn("Your version of `go` does not support modules. Disabling {}. Error: `{}`", (Object)"Golang Mod Analyzer", (Object)line);
                        throw new InitializationException("Go version does not support modules.");
                    }
                    if (reader == null) break;
                    if (var8_15 == null) ** GOTO lbl50
                    try {
                        reader.close();
                    }
                    catch (Throwable var9_17) {
                        var8_15.addSuppressed(var9_17);
                    }
                    break;
lbl50:
                    // 1 sources

                    reader.close();
                    ** break;
                    catch (Throwable var9_18) {
                        try {
                            var8_15 = var9_18;
                            throw var9_18;
                        }
                        catch (Throwable var10_19) {
                            if (reader != null) {
                                if (var8_15 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable var11_20) {
                                        var8_15.addSuppressed(var11_20);
                                    }
                                } else {
                                    reader.close();
                                }
                            }
                            throw var10_19;
lbl67:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    throw new InitializationException("Unexpected go encoding.", ex);
                }
                catch (IOException ex) {
                    throw new InitializationException("Unable to read go output.", ex);
                }
            }
        }
        msg = String.format("Unexpected exit code from go process. Disabling %s: %s", new Object[]{"Golang Mod Analyzer", exitValue});
        throw new InitializationException(msg);
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        int exitValue;
        File parentFile = dependency.getActualFile().getParentFile();
        Process process = this.launchGoMod(parentFile);
        try {
            exitValue = process.waitFor();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new AnalysisException("go process interrupted", ie);
        }
        if (exitValue < 0 || exitValue > 1) {
            String msg = String.format("Unexpected exit code from go process; exit code: %s", exitValue);
            throw new AnalysisException(msg);
        }
        try {
            StringBuilder error = new StringBuilder();
            try (BufferedReader errReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));){
                while (errReader.ready()) {
                    error.append(errReader.readLine());
                }
            }
            if (!error.toString().equals("")) {
                LOGGER.warn("Warnings from go {}", (Object)error.toString());
            }
            GoModJsonParser.process(process.getInputStream()).forEach(goDep -> engine.addDependency(goDep.toDependency(dependency)));
        }
        catch (IOException ioe) {
            LOGGER.warn("go mod failure", (Throwable)ioe);
        }
    }
}

