/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.util.List;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnusedSuppressionRuleAnalyzer
extends AbstractAnalyzer {
    protected static final String EXCEPTION_MSG = "There are %d unused suppression rule(s): check logs.";
    private static final Logger LOGGER = LoggerFactory.getLogger(UnusedSuppressionRuleAnalyzer.class);
    private boolean reported = false;
    private boolean shouldFailForUnusedSuppressionRule = false;
    private int unusedSuppressionRuleCount = 0;

    @Override
    public synchronized void initialize(Settings settings) {
        super.initialize(settings);
        if (settings.getBoolean("analyzer.suppression.unused.fail", false)) {
            this.shouldFailForUnusedSuppressionRule = true;
        }
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        if (!this.reported) {
            this.checkUnusedRules(engine);
            this.reported = true;
            if (this.unusedSuppressionRuleCount > 0 && this.failsForUnusedSuppressionRule()) {
                String message = String.format(EXCEPTION_MSG, this.unusedSuppressionRuleCount);
                LOGGER.error(message);
                throw new AnalysisException(message);
            }
        }
    }

    protected void checkUnusedRules(Engine engine) {
        if (engine.hasObject("suppression.rules")) {
            List rules = (List)engine.getObject("suppression.rules");
            rules.forEach(rule -> {
                if (!rule.isMatched() && !rule.isBase()) {
                    String message = String.format("Suppression Rule had zero matches: %s", rule);
                    if (this.failsForUnusedSuppressionRule()) {
                        LOGGER.error(message);
                    } else {
                        LOGGER.info(message);
                    }
                    this.increaseUnusedSuppressionRuleCount();
                }
            });
        }
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.vulnerabilitysuppression.enabled";
    }

    @Override
    public String getName() {
        return "Unused Suppression Rule Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINAL;
    }

    @Override
    public boolean supportsParallelProcessing() {
        return false;
    }

    public void increaseUnusedSuppressionRuleCount() {
        ++this.unusedSuppressionRuleCount;
    }

    public int getUnusedSuppressionRuleCount() {
        return this.unusedSuppressionRuleCount;
    }

    public boolean failsForUnusedSuppressionRule() {
        return this.shouldFailForUnusedSuppressionRule;
    }
}

