/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class PipfilelockAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipfilelockAnalyzer.class);
    private static final String LOCKFILE = "Pipfile.lock";
    private static final String ANALYZER_NAME = "Pipfile.lock Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addFilenames("Pipfile.lock").build();

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.pipfile.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        LOGGER.debug("Checking file {}", (Object)dependency.getActualFilePath());
        engine.removeDependency(dependency);
        File dependencyFile = dependency.getActualFile();
        if (!dependencyFile.isFile() || dependencyFile.length() == 0L) {
            return;
        }
        File actualFile = dependency.getActualFile();
        try (FileInputStream fin = new FileInputStream(actualFile);
             BufferedInputStream in = new BufferedInputStream(fin);
             JsonReader jsonReader = Json.createReader((InputStream)in);){
            JsonObject jsonLock = jsonReader.readObject();
            JsonObject develop = jsonLock.getJsonObject("develop");
            Set keys = develop.keySet();
            for (String identifiedPackage : keys) {
                JsonObject dep = develop.getJsonObject(identifiedPackage);
                String selectedVersion = dep.getString("version", "").trim();
                if (selectedVersion.startsWith("==") && selectedVersion.length() > 2) {
                    String identifiedVersion = selectedVersion.substring(2).trim();
                    LOGGER.debug("package, version: {} {}", (Object)identifiedPackage, (Object)identifiedVersion);
                    Dependency d = new Dependency(dependency.getActualFile(), true);
                    d.setName(identifiedPackage);
                    d.setVersion(identifiedVersion);
                    try {
                        PackageURL purl = PackageURLBuilder.aPackageURL().withType("pypi").withName(identifiedPackage).withVersion(identifiedVersion).build();
                        d.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
                    }
                    catch (MalformedPackageURLException ex) {
                        LOGGER.debug("Unable to build package url for pypi", (Throwable)ex);
                        d.addSoftwareIdentifier(new GenericIdentifier("pypi:" + identifiedPackage + "@" + identifiedVersion, Confidence.HIGH));
                    }
                    d.setPackagePath(String.format("%s:%s", identifiedPackage, identifiedVersion));
                    d.setEcosystem("python");
                    String filePath = String.format("%s:%s/%s", dependency.getFilePath(), identifiedPackage, identifiedVersion);
                    d.setFilePath(filePath);
                    d.setSha1sum(Checksum.getSHA1Checksum((String)filePath));
                    d.setSha256sum(Checksum.getSHA256Checksum((String)filePath));
                    d.setMd5sum(Checksum.getMD5Checksum((String)filePath));
                    d.addEvidence(EvidenceType.VENDOR, LOCKFILE, "vendor", identifiedPackage, Confidence.HIGHEST);
                    d.addEvidence(EvidenceType.PRODUCT, LOCKFILE, "product", identifiedPackage, Confidence.HIGHEST);
                    d.addEvidence(EvidenceType.VERSION, LOCKFILE, "version", identifiedVersion, Confidence.HIGHEST);
                    engine.addDependency(d);
                    continue;
                }
                LOGGER.debug("Skipping `{}`: Unknown version `{}` in `{}`", new Object[]{identifiedPackage, selectedVersion, dependency.getActualFilePath()});
            }
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (JsonException | IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getFileContents(File actualFile) throws AnalysisException {
        try {
            return new String(Files.readAllBytes(actualFile.toPath()), StandardCharsets.UTF_8).trim();
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }
}

