/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class PerlCpanfileAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerlCpanfileAnalyzer.class);
    private static final FileFilter PACKAGE_FILTER = FileFilterBuilder.newInstance().addFilenames("cpanfile").build();
    private static final Pattern VERSION_PATTERN = Pattern.compile("([0-9\\.]+)");

    @Override
    protected FileFilter getFileFilter() {
        return PACKAGE_FILTER;
    }

    @Override
    public String getName() {
        return "Perl cpanfile Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.cpanfile.enabled";
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        engine.removeDependency(dependency);
        String contents = this.tryReadFile(dependency.getActualFile());
        List<String> requires = this.prepareContents(contents);
        if (requires != null && !requires.isEmpty()) {
            this.processFileContents(requires, dependency.getFilePath(), engine);
        }
    }

    private String tryReadFile(File file) throws AnalysisException {
        try {
            return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8).trim();
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
    }

    protected List<String> prepareContents(String contents) {
        Pattern pattern = Pattern.compile(";");
        return Arrays.stream(contents.split("\n")).map(r -> r.indexOf("#") > 0 ? r.substring(0, r.indexOf("#")) : r).flatMap(pattern::splitAsStream).map(String::trim).filter(r -> r.startsWith("requires")).collect(Collectors.toCollection(ArrayList::new));
    }

    protected void processFileContents(List<String> fileLines, String filePath, Engine engine) throws AnalysisException {
        fileLines.stream().map(fileLine -> fileLine.split("(,|=>)")).map(requires -> {
            String name;
            String namespace;
            Matcher matcher;
            String fqName = requires[0].substring(8).replace("'", "").replace("\"", "").trim();
            String version = ((String[])requires).length == 1 ? "0" : ((matcher = VERSION_PATTERN.matcher(requires[1])).find() ? matcher.group(1) : "0");
            int pos = fqName.lastIndexOf("::");
            if (pos > 0) {
                namespace = fqName.substring(0, pos);
                name = fqName.substring(pos + 2);
            } else {
                namespace = null;
                name = fqName;
            }
            Dependency dependency = new Dependency(true);
            File f = new File(filePath);
            dependency.setFileName(f.getName());
            dependency.setFilePath(filePath);
            dependency.setActualFilePath(filePath);
            dependency.setDisplayFileName("'" + fqName + "', '" + version + "'");
            dependency.setEcosystem("perl");
            dependency.addEvidence(EvidenceType.VENDOR, "cpanfile", "requires", fqName, Confidence.HIGHEST);
            dependency.addEvidence(EvidenceType.PRODUCT, "cpanfile", "requires", fqName, Confidence.HIGHEST);
            dependency.addEvidence(EvidenceType.VERSION, "cpanfile", "requires", version, Confidence.HIGHEST);
            Identifier id = null;
            try {
                PackageURL purl = PackageURLBuilder.aPackageURL().withType("cpan").withNamespace(namespace).withName(name).withVersion(version).build();
                id = new PurlIdentifier(purl, Confidence.HIGH);
            }
            catch (MalformedPackageURLException ex) {
                LOGGER.debug("Error building package url for " + fqName + "; using generic identifier instead.", (Throwable)ex);
                id = new GenericIdentifier("cpan:" + fqName + "::" + version, Confidence.HIGH);
            }
            dependency.setVersion(version);
            dependency.setName(fqName);
            dependency.addSoftwareIdentifier(id);
            dependency.setSha1sum(Checksum.getSHA1Checksum((String)id.getValue()));
            return dependency;
        }).forEachOrdered(engine::addDependency);
    }
}

