/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nuget;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.owasp.dependencycheck.data.nuget.MSBuildProjectParseException;
import org.owasp.dependencycheck.utils.InterpolationUtil;
import org.owasp.dependencycheck.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DirectoryPackagesPropsParser {
    public Map<String, String> parse(InputStream stream, Properties props) throws MSBuildProjectParseException {
        try {
            DocumentBuilder db = XmlUtils.buildSecureDocumentBuilder();
            Document d = db.parse(stream);
            XPath xpath = XPathFactory.newInstance().newXPath();
            HashMap<String, String> packages = new HashMap<String, String>();
            Node centralNode = (Node)xpath.evaluate("/Project/PropertyGroup/ManagePackageVersionsCentrally", d, XPathConstants.NODE);
            if (centralNode != null && centralNode.getChildNodes().getLength() == 1) {
                String val = centralNode.getChildNodes().item(0).getNodeValue();
                if (!"true".equalsIgnoreCase(val)) {
                    return packages;
                }
            } else {
                return packages;
            }
            NodeList nodeList = (NodeList)xpath.evaluate("//PackageVersion", d, XPathConstants.NODESET);
            if (nodeList == null) {
                throw new MSBuildProjectParseException("Unable to parse Directory.Packages.props file");
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                NamedNodeMap attrs = node.getAttributes();
                Node includeAttr = attrs.getNamedItem("Include");
                if (includeAttr == null) continue;
                String include = includeAttr.getNodeValue();
                String version = null;
                if (attrs.getNamedItem("Version") != null) {
                    version = attrs.getNamedItem("Version").getNodeValue();
                } else if (xpath.evaluate("Version", node, XPathConstants.NODE) instanceof Node) {
                    version = ((Node)xpath.evaluate("Version", node, XPathConstants.NODE)).getTextContent();
                }
                if (include == null || version == null) continue;
                version = InterpolationUtil.interpolate(version, props, InterpolationUtil.SyntaxStyle.MSBUILD);
                packages.put(include, version);
            }
            return packages;
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | MSBuildProjectParseException | SAXException e) {
            throw new MSBuildProjectParseException("Unable to parse Directory.Packages.props file", e);
        }
    }
}

