/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nodeaudit;

import io.github.jeremylong.openvulnerability.client.nvd.CvssV3;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.owasp.dependencycheck.data.nodeaudit.Advisory;
import org.owasp.dependencycheck.utils.CvssUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpmAuditParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(NpmAuditParser.class);

    public List<Advisory> parse(JSONObject jsonResponse) throws JSONException {
        LOGGER.debug("Parsing JSON node");
        ArrayList<Advisory> advisories = new ArrayList<Advisory>();
        JSONObject jsonAdvisories = jsonResponse.getJSONObject("advisories");
        Iterator keys = jsonAdvisories.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Advisory advisory = this.parseAdvisory(jsonAdvisories.getJSONObject(key));
            advisories.add(advisory);
        }
        return advisories;
    }

    private Advisory parseAdvisory(JSONObject object) throws JSONException {
        JSONObject jsonCvss;
        Advisory advisory = new Advisory();
        advisory.setGhsaId(object.getString("github_advisory_id"));
        advisory.setOverview(object.optString("overview", null));
        advisory.setReferences(object.optString("references", null));
        advisory.setCreated(object.optString("created", null));
        advisory.setUpdated(object.optString("updated", null));
        advisory.setRecommendation(object.optString("recommendation", null));
        advisory.setTitle(object.optString("title", null));
        advisory.setModuleName(object.optString("module_name", null));
        advisory.setVulnerableVersions(object.optString("vulnerable_versions", null));
        advisory.setPatchedVersions(object.optString("patched_versions", null));
        advisory.setAccess(object.optString("access", null));
        advisory.setSeverity(object.optString("severity", null));
        JSONArray jsonCwes = object.optJSONArray("cwe");
        ArrayList<String> stringCwes = new ArrayList<String>();
        if (jsonCwes != null) {
            for (int j = 0; j < jsonCwes.length(); ++j) {
                stringCwes.add(jsonCwes.getString(j));
            }
        }
        advisory.setCwes(stringCwes);
        JSONArray findings = object.optJSONArray("findings");
        for (int i = 0; i < findings.length(); ++i) {
            JSONObject finding = findings.getJSONObject(i);
            String version = finding.optString("version", null);
            JSONArray paths = finding.optJSONArray("paths");
            for (int j = 0; j < paths.length(); ++j) {
                String path = paths.getString(j);
                if (path == null || !path.equals(advisory.getModuleName())) continue;
                advisory.setVersion(version);
            }
        }
        JSONArray jsonCves = object.optJSONArray("cves");
        ArrayList<String> stringCves = new ArrayList<String>();
        if (jsonCves != null) {
            for (int j = 0; j < jsonCves.length(); ++j) {
                stringCves.add(jsonCves.getString(j));
            }
            advisory.setCves(stringCves);
        }
        if ((jsonCvss = object.optJSONObject("cvss")) != null) {
            String vector;
            double baseScore = -1.0;
            String score = jsonCvss.optString("score");
            if (score != null) {
                try {
                    baseScore = Float.parseFloat(score);
                }
                catch (NumberFormatException ignored) {
                    LOGGER.trace("Swallowed NumberFormatException", (Throwable)ignored);
                    baseScore = -1.0;
                }
            }
            if (baseScore >= 0.0 && (vector = jsonCvss.optString("vectorString")) != null && !"null".equals(vector)) {
                if (vector.startsWith("CVSS:3") && baseScore >= 0.0) {
                    try {
                        CvssV3 cvss = CvssUtil.vectorToCvssV3(vector, baseScore);
                        advisory.setCvssV3(cvss);
                    }
                    catch (IllegalArgumentException iae) {
                        LOGGER.warn("Invalid CVSS vector format encountered in NPM Audit results '{}': {} ", (Object)vector, (Object)iae.getMessage());
                    }
                } else {
                    LOGGER.warn("Unsupported CVSS vector format in NPM Audit results, please file a feature request at https://github.com/dependency-check/DependencyCheck/issues/new/choose to support vector format '{}' ", (Object)vector);
                }
            }
        }
        return advisory;
    }
}

