/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import io.github.jeremylong.openvulnerability.client.nvd.CvssV2;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV2Data;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV3;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV3Data;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.sonatype.ossindex.service.api.cvss.Cvss3Severity;

public final class CvssUtil {
    private static final List<String> BASE_METRICS_V3 = Arrays.asList("AV", "AC", "PR", "UI", "S", "C", "I", "A");
    private static final List<String> BASE_METRICS_V2 = Arrays.asList("AV", "AC", "Au", "C", "I", "A");
    private static final Double ZERO = 0.0;
    private static final Double ONE = 1.0;
    private static final Double FOUR = 4.0;
    private static final Double SEVEN = 7.0;
    private static final Double NINE = 9.0;
    private static final Double TEN = 10.0;
    private static final String UNKNOWN = "UNKNOWN";
    private static final String HIGH = "HIGH";
    private static final String MEDIUM = "MEDIUM";
    private static final String LOW = "LOW";

    private CvssUtil() {
    }

    public static CvssV2 vectorToCvssV2(String vectorString, Double baseScore) {
        if (vectorString.startsWith("CVSS:")) {
            throw new IllegalArgumentException("Not a valid CVSSv2 vector string: " + vectorString);
        }
        String[] metricStrings = vectorString.substring(vectorString.indexOf(47) + 1).split("/");
        HashMap<String, String> metrics = new HashMap<String, String>();
        for (int i = 0; i < metricStrings.length; ++i) {
            String[] metricKeyVal = metricStrings[i].split(":");
            if (metricKeyVal.length != 2) {
                throw new IllegalArgumentException(String.format("Not a valid CVSSv2 vector string '%s', invalid metric component '%s'", vectorString, metricStrings[i]));
            }
            metrics.put(metricKeyVal[0], metricKeyVal[1]);
        }
        if (!metrics.keySet().containsAll(BASE_METRICS_V2)) {
            throw new IllegalArgumentException(String.format("Not a valid CVSSv2 vector string '%s'; missing one or more required Metrics;", vectorString));
        }
        CvssV2Data.AccessVectorType accessVector = CvssV2Data.AccessVectorType.fromValue((String)((String)metrics.get("AV")));
        CvssV2Data.AccessComplexityType attackComplexity = CvssV2Data.AccessComplexityType.fromValue((String)((String)metrics.get("AC")));
        CvssV2Data.AuthenticationType authentication = CvssV2Data.AuthenticationType.fromValue((String)((String)metrics.get("Au")));
        CvssV2Data.CiaType confidentialityImpact = CvssV2Data.CiaType.fromValue((String)((String)metrics.get("C")));
        CvssV2Data.CiaType integrityImpact = CvssV2Data.CiaType.fromValue((String)((String)metrics.get("I")));
        CvssV2Data.CiaType availabilityImpact = CvssV2Data.CiaType.fromValue((String)((String)metrics.get("A")));
        String baseSeverity = CvssUtil.cvssV2ScoreToSeverity(baseScore);
        CvssV2Data data = new CvssV2Data(CvssV2Data.Version._2_0, vectorString, accessVector, attackComplexity, authentication, confidentialityImpact, integrityImpact, availabilityImpact, baseScore, baseSeverity, null, null, null, null, null, null, null, null, null, null);
        CvssV2 cvss = new CvssV2(null, null, data, baseSeverity, null, null, null, null, null, null, null);
        return cvss;
    }

    public static String cvssV2ScoreToSeverity(Double score) {
        if (score != null) {
            if (ZERO.compareTo(score) <= 0 && FOUR.compareTo(score) > 0) {
                return LOW;
            }
            if (FOUR.compareTo(score) <= 0 && SEVEN.compareTo(score) > 0) {
                return MEDIUM;
            }
            if (SEVEN.compareTo(score) <= 0 && TEN.compareTo(score) >= 0) {
                return HIGH;
            }
        }
        return UNKNOWN;
    }

    public static CvssV3Data.SeverityType cvssV3ScoreToSeverity(Double score) {
        if (score != null) {
            if (ZERO.compareTo(score) == 0) {
                return CvssV3Data.SeverityType.NONE;
            }
            if (ZERO.compareTo(score) <= 0 && FOUR.compareTo(score) > 0) {
                return CvssV3Data.SeverityType.LOW;
            }
            if (FOUR.compareTo(score) <= 0 && SEVEN.compareTo(score) > 0) {
                return CvssV3Data.SeverityType.MEDIUM;
            }
            if (SEVEN.compareTo(score) <= 0 && NINE.compareTo(score) > 0) {
                return CvssV3Data.SeverityType.HIGH;
            }
            if (NINE.compareTo(score) <= 0 && TEN.compareTo(score) >= 0) {
                return CvssV3Data.SeverityType.CRITICAL;
            }
        }
        return null;
    }

    public static CvssV3 vectorToCvssV3(String vectorString, Double baseScore) {
        if (!vectorString.startsWith("CVSS:3")) {
            throw new IllegalArgumentException("Not a valid CVSSv3 vector string: " + vectorString);
        }
        String versionString = vectorString.substring(5, vectorString.indexOf(47));
        String[] metricStrings = vectorString.substring(vectorString.indexOf(47) + 1).split("/");
        HashMap<String, String> metrics = new HashMap<String, String>();
        for (int i = 0; i < metricStrings.length; ++i) {
            String[] metricKeyVal = metricStrings[i].split(":");
            if (metricKeyVal.length != 2) {
                throw new IllegalArgumentException(String.format("Not a valid CVSSv3 vector string '%s', invalid metric component '%s'", vectorString, metricStrings[i]));
            }
            metrics.put(metricKeyVal[0], metricKeyVal[1]);
        }
        if (!metrics.keySet().containsAll(BASE_METRICS_V3)) {
            throw new IllegalArgumentException(String.format("Not a valid CVSSv3 vector string '%s'; missing one or more required Base Metrics;", vectorString));
        }
        CvssV3Data.Version version = CvssV3Data.Version.fromValue((String)versionString);
        CvssV3Data.AttackVectorType attackVector = CvssV3Data.AttackVectorType.fromValue((String)((String)metrics.get("AV")));
        CvssV3Data.AttackComplexityType attackComplexity = CvssV3Data.AttackComplexityType.fromValue((String)((String)metrics.get("AC")));
        CvssV3Data.PrivilegesRequiredType privilegesRequired = CvssV3Data.PrivilegesRequiredType.fromValue((String)((String)metrics.get("PR")));
        CvssV3Data.UserInteractionType userInteraction = CvssV3Data.UserInteractionType.fromValue((String)((String)metrics.get("UI")));
        CvssV3Data.ScopeType scope = CvssV3Data.ScopeType.fromValue((String)((String)metrics.get("S")));
        CvssV3Data.CiaType confidentialityImpact = CvssV3Data.CiaType.fromValue((String)((String)metrics.get("C")));
        CvssV3Data.CiaType integrityImpact = CvssV3Data.CiaType.fromValue((String)((String)metrics.get("I")));
        CvssV3Data.CiaType availabilityImpact = CvssV3Data.CiaType.fromValue((String)((String)metrics.get("A")));
        String baseSeverityString = Cvss3Severity.of((Float)Float.valueOf(baseScore.floatValue())).name();
        CvssV3Data.SeverityType baseSeverity = CvssV3Data.SeverityType.fromValue((String)baseSeverityString);
        CvssV3Data data = new CvssV3Data(version, vectorString, attackVector, attackComplexity, privilegesRequired, userInteraction, scope, confidentialityImpact, integrityImpact, availabilityImpact, baseScore, baseSeverity, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        CvssV3 cvss = new CvssV3(null, null, data, null, null);
        return cvss;
    }
}

