/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.http.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.osgl.http.H;
import org.osgl.http.servlet.ServletCookie;
import org.osgl.util.E;
import org.osgl.util.Output;

public class ServletResponse
extends H.Response<ServletResponse> {
    private HttpServletResponse r;
    private int statusCode = -1;

    @Override
    protected Class<ServletResponse> _impl() {
        return ServletResponse.class;
    }

    public ServletResponse(HttpServletResponse resp) {
        E.NPE((Object)resp);
        this.r = resp;
    }

    @Override
    public String characterEncoding() {
        return this.r.getCharacterEncoding();
    }

    @Override
    public ServletResponse characterEncoding(String encoding) {
        this.r.setCharacterEncoding(encoding);
        return this;
    }

    @Override
    public ServletResponse contentLength(long len) {
        this.r.setContentLength((int)len);
        return this;
    }

    @Override
    public ServletResponse writeContent(ByteBuffer buffer) {
        throw E.unsupport((String)"Writing direct byte buffer is not supported by ServletResponse", (Object[])new Object[0]);
    }

    @Override
    protected OutputStream createOutputStream() {
        try {
            return this.r.getOutputStream();
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    @Override
    protected Output createOutput() {
        try {
            return Output.Adaptors.of((OutputStream)this.r.getOutputStream());
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    @Override
    protected void _setContentType(String type) {
        this.r.setContentType(type);
    }

    @Override
    protected void _setLocale(Locale loc) {
        this.r.setLocale(loc);
    }

    @Override
    public Locale locale() {
        return this.r.getLocale();
    }

    @Override
    public void addCookie(H.Cookie cookie) {
        this.r.addCookie(ServletCookie.asServletCookie(cookie));
    }

    @Override
    public boolean containsHeader(String name) {
        return this.r.containsHeader(name);
    }

    @Override
    public ServletResponse sendError(int statusCode, String msg) {
        try {
            this.r.sendError(statusCode, msg);
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
        return this;
    }

    @Override
    public ServletResponse sendError(int statusCode) {
        try {
            this.r.sendError(statusCode);
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
        return this;
    }

    @Override
    public ServletResponse sendRedirect(String location) {
        try {
            this.r.sendRedirect(location);
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
        return this;
    }

    @Override
    public ServletResponse header(String name, String value) {
        this.r.setHeader(name, value);
        return this;
    }

    @Override
    public ServletResponse status(int statusCode) {
        this.r.setStatus(statusCode);
        this.statusCode = statusCode;
        return this;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public ServletResponse addHeader(String name, String value) {
        this.r.addHeader(name, value);
        return this;
    }

    @Override
    public void commit() {
        try {
            this.r.flushBuffer();
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }
}

