/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.aaa.impl;

import java.util.Collection;
import java.util.List;
import org.osgl.Lang;
import org.osgl.aaa.AAAObject;
import org.osgl.aaa.Permission;
import org.osgl.aaa.Principal;
import org.osgl.aaa.Privilege;
import org.osgl.aaa.Role;
import org.osgl.aaa.impl.AAAObjectBase;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class SimplePrincipal
extends AAAObjectBase
implements Principal {
    public static final Lang.Func1<Permission, Iterable<Permission>> EXPAND_PERMISSION = new Lang.Func1<Permission, Iterable<Permission>>(){

        public Iterable<Permission> apply(Permission permission) throws NotAppliedException, Lang.Break {
            return permission.implied();
        }
    };
    private Privilege privilege;
    private List<? extends Role> roles = C.list();
    private List<? extends Permission> perms = C.list();

    public SimplePrincipal() {
    }

    public SimplePrincipal(String name, Privilege privilege, Collection<? extends Role> roles, Collection<? extends Permission> perms) {
        super(name);
        this.privilege = privilege;
        C.List emptyRoles = C.list();
        this.roles = null == roles ? emptyRoles : C.list(roles);
        C.List emptyPerms = C.list();
        this.perms = null == perms ? emptyPerms : C.list(perms);
    }

    @Override
    public Privilege getPrivilege() {
        return this.privilege;
    }

    public C.List<Role> getRoles() {
        return C.list(this.roles);
    }

    public C.List<Permission> getPermissions() {
        return C.list(this.perms);
    }

    public static final Principal createSystemPrincipal(String name) {
        C.List roles = C.list();
        C.List perms = C.list();
        return new SimplePrincipal(name, null, (Collection<? extends Role>)roles, (Collection<? extends Permission>)perms);
    }

    public static class Builder {
        private String name;
        private Privilege privilege;
        private C.List<Role> roles = C.newList();
        private C.List<Permission> perms = C.newList();

        public Builder(Principal copy) {
            this.name = copy.getName();
            this.privilege = copy.getPrivilege();
            this.roles.addAll(copy.getRoles());
            this.perms.addAll(copy.getPermissions());
        }

        public Builder(String name) {
            E.illegalArgumentIf((boolean)S.blank((String)name));
            this.name = name;
        }

        public Builder grantPrivilege(Privilege p) {
            this.privilege = p;
            return this;
        }

        public Builder revokePrivilege() {
            this.privilege = null;
            return this;
        }

        public Builder grantRole(Role role) {
            this.roles.add((Object)role);
            return this;
        }

        public Builder revokeRole(String roleName) {
            this.roles = this.roles.remove(AAAObject.F.nameMatcher(roleName));
            return this;
        }

        public Builder revokeAllRoles() {
            this.roles.clear();
            return this;
        }

        public Builder grantPermission(Permission perm) {
            this.perms.add((Object)perm);
            return this;
        }

        public Builder revokePermission(String permName) {
            this.perms = this.perms.remove(AAAObject.F.nameMatcher(permName));
            return this;
        }

        public Builder revokeAllPermissions() {
            this.perms.clear();
            return this;
        }

        public SimplePrincipal toPrincipal() {
            return new SimplePrincipal(this.name, this.privilege, (Collection<? extends Role>)this.roles, (Collection<? extends Permission>)this.perms);
        }
    }
}

