/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.aaa.impl;

import java.util.Collection;
import java.util.Set;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.aaa.AAAContext;
import org.osgl.aaa.AuthorizationService;
import org.osgl.aaa.Permission;
import org.osgl.aaa.Principal;
import org.osgl.aaa.Privilege;
import org.osgl.aaa.Role;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;

public class SimpleAuthorizationService
implements AuthorizationService {
    private static Logger logger = LogManager.get(SimpleAuthorizationService.class);

    @Override
    public Privilege getPrivilege(Principal principal, AAAContext context) {
        return principal.getPrivilege();
    }

    @Override
    public Collection<Role> getRoles(Principal principal, AAAContext context) {
        return principal.getRoles();
    }

    @Override
    public Collection<Permission> getPermissions(Role role, AAAContext context) {
        return role.getPermissions();
    }

    @Override
    public Collection<Permission> getPermissions(Principal principal, AAAContext context) {
        return principal.getPermissions();
    }

    @Override
    public Collection<Permission> getAllPermissions(Principal principal, AAAContext context) {
        C.List perms = C.newList(this.getPermissions(principal, context)).lazy();
        C.list(this.getRoles(principal, context)).accept($.visitor((Lang.Function)Role.F.PERMISSION_GETTER.andThen((Lang.Function)C.F.addAllTo((Collection)perms))));
        C.Set retVal = C.newSet();
        for (Permission p : perms) {
            if (null == p) {
                logger.warn((Throwable)new RuntimeException(), "Null permission found on principal %s", new Object[]{principal.getName()});
                continue;
            }
            this.collectPermission((Set<Permission>)retVal, p);
        }
        return retVal;
    }

    private void collectPermission(Set<Permission> set, Permission p) {
        Set<Permission> implied = p.implied();
        if (null == implied) {
            logger.warn((Throwable)new RuntimeException(""), "Null implied found on permission: %s", new Object[]{p.getName()});
        }
        for (Permission p0 : p.implied()) {
            if (p0 == p) continue;
            this.collectPermission(set, p0);
        }
        set.add(p);
    }
}

