/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.aaa.impl;

import org.osgl.$;
import org.osgl.aaa.AAAPersistentService;
import org.osgl.aaa.Auditor;
import org.osgl.aaa.AuthenticationService;
import org.osgl.aaa.AuthorizationService;
import org.osgl.aaa.Principal;
import org.osgl.aaa.Privilege;
import org.osgl.aaa.impl.AAAContextBase;
import org.osgl.aaa.impl.DumbAuditor;
import org.osgl.aaa.impl.SimplePrincipal;

public class SimpleAAAContext
extends AAAContextBase {
    private boolean allowSystem = true;
    private Principal system;
    private int superUserLevel = 9999;
    private AuthenticationService authen;
    private AuthorizationService author;
    private AAAPersistentService db;
    private Auditor auditor;

    public SimpleAAAContext(AuthenticationService authenticationService, AuthorizationService authorizationService, AAAPersistentService aaaPersistentService, Auditor auditorImpl, int superUserLevel, Principal system, boolean allowSystem) {
        this.authen = (AuthenticationService)$.NPE((Object)authenticationService);
        this.author = (AuthorizationService)$.NPE((Object)authorizationService);
        this.db = (AAAPersistentService)$.NPE((Object)aaaPersistentService);
        this.auditor = null == auditorImpl ? DumbAuditor.INSTANCE : auditorImpl;
        this.superUserLevel = superUserLevel;
        this.allowSystem = allowSystem;
        if (allowSystem) {
            this.system = system == null ? SimplePrincipal.createSystemPrincipal("__sys") : system;
        }
    }

    public SimpleAAAContext(AuthenticationService authenticationService, AuthorizationService authorizationService, AAAPersistentService aaaPersistentService) {
        this(authenticationService, authorizationService, aaaPersistentService, DumbAuditor.INSTANCE, 9999, null, true);
    }

    public SimpleAAAContext(AuthenticationService authenticationService, AuthorizationService authorizationService, AAAPersistentService aaaPersistentService, Auditor auditor) {
        this(authenticationService, authorizationService, aaaPersistentService, auditor, 9999, null, true);
    }

    @Override
    public AuthenticationService getAuthenticationService() {
        return this.authen;
    }

    @Override
    public AuthorizationService getAuthorizationService() {
        return this.author;
    }

    @Override
    public AAAPersistentService getPersistentService() {
        return this.db;
    }

    @Override
    public Auditor getAuditor() {
        return this.auditor;
    }

    @Override
    public boolean allowSuperUser() {
        return this.allowSystem;
    }

    @Override
    public boolean isSuperUser(Principal principal) {
        Privilege p = principal.getPrivilege();
        if (null == p) {
            return false;
        }
        return p.getLevel() >= this.getSuperUserLevel();
    }

    @Override
    public Principal getSystemPrincipal() {
        return this.system;
    }

    @Override
    public int getSuperUserLevel() {
        return this.superUserLevel;
    }
}

