/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.aaa;

import java.util.Collection;
import java.util.List;
import org.osgl.Lang;
import org.osgl.aaa.AAAObject;
import org.osgl.aaa.Permission;
import org.osgl.aaa.Privilege;
import org.osgl.aaa.Role;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.C;

public interface Principal
extends AAAObject,
java.security.Principal {
    public Privilege getPrivilege();

    public List<Role> getRoles();

    public List<Permission> getPermissions();

    public static abstract class F
    extends AAAObject.F {
        public static Lang.F1<Principal, C.List<Role>> ROLE_GETTER = new Lang.F1<Principal, C.List<Role>>(){

            public C.List<Role> apply(Principal principal) throws NotAppliedException, Lang.Break {
                return C.list(principal.getRoles());
            }
        };
        public static Lang.F1<Principal, C.List<Permission>> PERMISSION_GETTER = new Lang.F1<Principal, C.List<Permission>>(){

            public C.List<Permission> apply(Principal principal) throws NotAppliedException, Lang.Break {
                return C.list(principal.getPermissions());
            }
        };
        public static Lang.F1<Principal, C.List<Permission>> ALL_PERMISSION_GETTER = new Lang.F1<Principal, C.List<Permission>>(){

            public C.List<Permission> apply(Principal principal) throws NotAppliedException, Lang.Break {
                return C.list(F.allPermissionsOf(principal));
            }
        };

        public static Lang.Visitor<Principal> roleVisitor(final Lang.Visitor<Role> visitor) {
            return new Lang.Visitor<Principal>(){

                public void visit(Principal principal) throws Lang.Break {
                    C.list(principal.getRoles()).accept(visitor);
                }
            };
        }

        public static Lang.Visitor<Principal> permissionVisitor(final Lang.Visitor<Permission> visitor) {
            return new Lang.Visitor<Principal>(){

                public void visit(Principal principal) throws Lang.Break {
                    C.list(principal.getPermissions()).accept(visitor);
                }
            };
        }

        public static Lang.Visitor<Principal> allPermissionVisitor(final Lang.Visitor<Permission> visitor) {
            return new Lang.Visitor<Principal>(){

                public void visit(Principal principal) throws Lang.Break {
                    C.list(F.allPermissionsOf(principal)).accept(visitor);
                }
            };
        }

        public static List<Permission> allPermissionsOf(Principal principal) {
            C.Set set = C.newSet(principal.getPermissions());
            for (Role role : principal.getRoles()) {
                set.addAll(role.getPermissions());
            }
            return C.list((Collection)set);
        }
    }
}

