/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.aaa;

import org.osgl.aaa.AAA;
import org.osgl.aaa.AAAPersistentService;
import org.osgl.aaa.Auditor;
import org.osgl.aaa.AuthenticationService;
import org.osgl.aaa.AuthorizationService;
import org.osgl.aaa.Permission;
import org.osgl.aaa.Principal;
import org.osgl.aaa.Privilege;
import org.osgl.aaa.Role;
import org.osgl.aaa.impl.Anonymous;
import org.osgl.aaa.impl.SimplePrivilege;
import org.osgl.exception.AccessDeniedException;

public abstract class AAAContext {
    public abstract AuthenticationService getAuthenticationService();

    public abstract AuthorizationService getAuthorizationService();

    public abstract AAAPersistentService getPersistentService();

    public abstract Auditor getAuditor();

    public abstract Principal getSystemPrincipal();

    protected Anonymous getAnonymousPrincipal() {
        return Anonymous.INSTANCE;
    }

    public abstract int getSuperUserLevel();

    public abstract boolean allowSuperUser();

    public abstract boolean isSuperUser(Principal var1);

    public abstract void setCurrentPrincipal(Principal var1);

    public abstract Principal getCurrentPrincipal();

    public Principal getPrincipal(boolean allowSystem) {
        Principal p = this.getCurrentPrincipal();
        if (null != p) {
            return p;
        }
        if (allowSystem) {
            p = this.getSystemPrincipal();
        }
        return null != p ? p : this.getAnonymousPrincipal();
    }

    public abstract Object setGuardedTarget(Object var1);

    public abstract Object getGuardedTarget();

    public Privilege findPrivilege(int level) {
        Privilege p = this.getPersistentService().findPrivilege(level);
        return null != p ? p : new SimplePrivilege("p-" + level, level);
    }

    public Iterable<Privilege> allPrivileges() {
        return this.getPersistentService().allPrivileges();
    }

    public Iterable<Permission> allPermissions() {
        return this.getPersistentService().allPermissions();
    }

    public Iterable<Role> allRoles() {
        return this.getPersistentService().allRoles();
    }

    public Iterable<String> allPrivilegeNames() {
        return this.getPersistentService().allPrivilegeNames();
    }

    public Iterable<String> allPermissionNames() {
        return this.getPersistentService().allPermissionNames();
    }

    public Iterable<String> allRoleNames() {
        return this.getPersistentService().allRoleNames();
    }

    public boolean hasPermission(Permission permission) throws AccessDeniedException {
        return AAA.hasPermission(null, permission, true, this);
    }

    public boolean hasPermission(String permissionName) throws AccessDeniedException {
        return AAA.hasPermission(null, permissionName, true, this);
    }

    public boolean hasPermission(Enum<?> permissionEnum) throws AccessDeniedException {
        return AAA.hasPermission(null, permissionEnum, true, this);
    }

    public boolean hasPermission(Permission permissionName, boolean allowSystem) throws AccessDeniedException {
        return AAA.hasPermission(null, permissionName, allowSystem, this);
    }

    public boolean hasPermission(String permissionName, boolean allowSystem) throws AccessDeniedException {
        return AAA.hasPermission(null, permissionName, allowSystem, this);
    }

    public boolean hasPermission(Enum<?> permissionEnum, boolean allowSystem) throws AccessDeniedException {
        return AAA.hasPermission(null, permissionEnum, allowSystem, this);
    }

    public boolean hasPermission(Object guardedResource, Permission permission) throws AccessDeniedException {
        return AAA.hasPermission(guardedResource, permission, true, this);
    }

    public boolean hasPermission(Object guardedResource, String permissionName) throws AccessDeniedException {
        return AAA.hasPermission(guardedResource, permissionName, true, this);
    }

    public boolean hasPermission(Object guardedResource, Enum<?> permissionEnum) throws AccessDeniedException {
        return AAA.hasPermission(guardedResource, permissionEnum, true, this);
    }

    public boolean hasPermission(Object guardedResource, Permission permission, boolean allowSystem) {
        return AAA.hasPermission(guardedResource, permission, allowSystem, this);
    }

    public boolean hasPermission(Object guardedResource, String permissionName, boolean allowSystem) {
        return AAA.hasPermission(guardedResource, permissionName, allowSystem, this);
    }

    public boolean hasPermission(Object guardedResource, Enum<?> permissionEnum, boolean allowSystem) {
        return AAA.hasPermission(guardedResource, permissionEnum, allowSystem, this);
    }

    public boolean hasPermission(Principal principal, Permission permission) throws AccessDeniedException {
        return AAA.hasPermission(null, principal, permission, this);
    }

    public boolean hasPermission(Principal principal, String permissionName) throws AccessDeniedException {
        return AAA.hasPermission(null, principal, permissionName, this);
    }

    public boolean hasPermission(Principal principal, Enum<?> permissionEnum) throws AccessDeniedException {
        return AAA.hasPermission(null, principal, permissionEnum, this);
    }

    public boolean hasPermission(Principal principal, Object guardedResource, String permissionName) throws AccessDeniedException {
        return AAA.hasPermission(guardedResource, principal, permissionName, this);
    }

    public boolean hasPermission(Principal principal, Object guardedResource, Enum<?> permissionEnum) throws AccessDeniedException {
        return AAA.hasPermission(guardedResource, principal, permissionEnum, this);
    }

    public void requirePermission(Permission permission) throws AccessDeniedException {
        AAA.requirePermission(null, permission, this);
    }

    public void requirePermission(String permissionName) throws AccessDeniedException {
        AAA.requirePermission(null, permissionName, this);
    }

    public void requirePermission(Enum<?> permissionEnum) throws AccessDeniedException {
        AAA.requirePermission(null, permissionEnum, this);
    }

    public void requirePermission(Permission permissionName, boolean allowSystem) throws AccessDeniedException {
        AAA.requirePermission(null, permissionName, allowSystem, this);
    }

    public void requirePermission(String permissionName, boolean allowSystem) throws AccessDeniedException {
        AAA.requirePermission(null, permissionName, allowSystem, this);
    }

    public void requirePermission(Enum<?> permissionEnum, boolean allowSystem) throws AccessDeniedException {
        AAA.requirePermission(null, permissionEnum, allowSystem, this);
    }

    public void requirePermission(Object guardedResource, Permission permission) throws AccessDeniedException {
        AAA.requirePermission(guardedResource, permission, this);
    }

    public void requirePermission(Object guardedResource, String permissionName) throws AccessDeniedException {
        AAA.requirePermission(guardedResource, permissionName, this);
    }

    public void requirePermission(Object guardedResource, Enum<?> permissionEnum) throws AccessDeniedException {
        AAA.requirePermission(guardedResource, permissionEnum, this);
    }

    public void requirePermission(Object guardedResource, Permission permission, boolean allowSystem) {
        AAA.requirePermission(guardedResource, permission, allowSystem, this);
    }

    public void requirePermission(Object guardedResource, String permissionName, boolean allowSystem) {
        AAA.requirePermission(guardedResource, permissionName, allowSystem, this);
    }

    public void requirePermission(Object guardedResource, Enum<?> permissionEnum, boolean allowSystem) {
        AAA.requirePermission(guardedResource, permissionEnum, allowSystem, this);
    }

    public void requirePermission(Principal principal, Permission permission) throws AccessDeniedException {
        AAA.requirePermission(null, principal, permission, this);
    }

    public void requirePermission(Principal principal, String permissionName) throws AccessDeniedException {
        AAA.requirePermission(null, principal, permissionName, this);
    }

    public void requirePermission(Principal principal, Enum<?> permissionEnum) throws AccessDeniedException {
        AAA.requirePermission(null, principal, permissionEnum, this);
    }

    public void requirePermission(Principal principal, Object guardedResource, String permissionName) throws AccessDeniedException {
        AAA.requirePermission(guardedResource, principal, permissionName, this);
    }

    public void requirePermission(Principal principal, Object guardedResource, Enum<?> permissionEnum) throws AccessDeniedException {
        AAA.requirePermission(guardedResource, principal, permissionEnum, this);
    }

    public boolean hasPrivilege(Privilege privilege) {
        return AAA.hasPrivilege(privilege, true, this);
    }

    public boolean hasPrivilege(String privilegeName) {
        return AAA.hasPrivilege(privilegeName, true, this);
    }

    public boolean hasPrivilege(Enum<?> privilegeEnum) {
        return AAA.hasPrivilege(privilegeEnum, true, this);
    }

    public boolean hasPrivilege(int privilegeLevel) {
        return AAA.hasPrivilege(privilegeLevel, true, this);
    }

    public boolean hasPrivilege(Principal principal, Privilege privilege) {
        return AAA.hasPrivilege(principal, privilege, this);
    }

    public boolean hasPrivilege(Principal principal, String privilegeName) {
        return AAA.hasPrivilege(principal, privilegeName, this);
    }

    public boolean hasPrivilege(Principal principal, Enum<?> privilegeEnum) {
        return AAA.hasPrivilege(principal, privilegeEnum, this);
    }

    public boolean hasPrivilege(Principal principal, int privilegeLevel) {
        return AAA.hasPrivilege(principal, privilegeLevel, this);
    }

    public boolean hasPrivilege(Privilege privilege, boolean allowSystem) {
        return AAA.hasPrivilege(privilege, allowSystem, this);
    }

    public boolean hasPrivilege(String privilegeName, boolean allowSystem) {
        return AAA.hasPrivilege(privilegeName, allowSystem, this);
    }

    public boolean hasPrivilege(Enum<?> privilegeEnum, boolean allowSystem) {
        return AAA.hasPrivilege(privilegeEnum, allowSystem, this);
    }

    public boolean hasPrivilege(int privilegeLevel, boolean allowSystem) {
        return AAA.hasPrivilege(privilegeLevel, allowSystem, this);
    }

    public void requirePrivilege(Privilege privilege) {
        AAA.requirePrivilege(privilege, this);
    }

    public void requirePrivilege(String privilegeName) {
        AAA.requirePrivilege(privilegeName, this);
    }

    public void requirePrivilege(Enum<?> privilegeEnum) {
        AAA.requirePrivilege(privilegeEnum, this);
    }

    public void requirePrivilege(int privilegeLevel) {
        AAA.requirePrivilege(privilegeLevel, this);
    }

    public void requirePrivilege(Principal principal, Privilege privilege) {
        AAA.requirePrivilege(principal, privilege, this);
    }

    public void requirePrivilege(Principal principal, String privilegeName) {
        AAA.requirePrivilege(principal, privilegeName, this);
    }

    public void requirePrivilege(Principal principal, Enum<?> privilegeEnum) {
        AAA.requirePrivilege(principal, privilegeEnum, this);
    }

    public void requirePrivilege(Principal principal, int privilegeLevel) {
        AAA.requirePrivilege(principal, privilegeLevel, this);
    }

    public void requirePrivilege(Privilege privilege, boolean allowSystem) {
        AAA.requirePrivilege(privilege, allowSystem, this);
    }

    public void requirePrivilege(String privilegeName, boolean allowSystem) {
        AAA.requirePrivilege(privilegeName, allowSystem, this);
    }

    public void requirePrivilege(Enum<?> privilegeEnum, boolean allowSystem) {
        AAA.requirePrivilege(privilegeEnum, allowSystem, this);
    }

    public void requirePrivilege(int privilegeLevel, boolean allowSystem) {
        AAA.requirePrivilege(privilegeLevel, allowSystem, this);
    }

    public boolean hasPermissionOrPrivilege(Permission permission, Privilege privilege) {
        return AAA.hasPermissionOrPrivilege(permission, privilege, this);
    }

    public boolean hasPermissionOrPrivilege(String permissionName, String privilegeName) {
        return AAA.hasPermissionOrPrivilege(permissionName, privilegeName, this);
    }

    public boolean hasPermissionOrPrivilege(String permissionName, int privilegeLevel) {
        return AAA.hasPermissionOrPrivilege(permissionName, privilegeLevel, this);
    }

    public boolean hasPermissionOrPrivilege(Enum<?> permissionEnum, Enum<?> privilegeEnum) {
        return AAA.hasPermissionOrPrivilege(permissionEnum, privilegeEnum, this);
    }

    public boolean hasPermissionOrPrivilege(Enum<?> permissionEnum, int privilegeLevel) {
        return AAA.hasPermissionOrPrivilege(permissionEnum, privilegeLevel, this);
    }

    public boolean hasPermissionOrPrivilege(Permission permission, Privilege privilege, boolean allowSystem) {
        return AAA.hasPermissionOrPrivilege(permission, privilege, allowSystem, this);
    }

    public boolean hasPermissionOrPrivilege(String permissionName, String privilegeName, boolean allowSystem) {
        return AAA.hasPermissionOrPrivilege(permissionName, privilegeName, allowSystem, this);
    }

    public boolean hasPermissionOrPrivilege(String permissionName, int privilegeLevel, boolean allowSystem) {
        return AAA.hasPermissionOrPrivilege(permissionName, privilegeLevel, allowSystem, this);
    }

    public boolean hasPermissionOrPrivilege(Enum<?> permissionEnum, Enum<?> privilegeEnum, boolean allowSystem) {
        return AAA.hasPermissionOrPrivilege(permissionEnum, privilegeEnum, allowSystem, this);
    }

    public boolean hasPermissionOrPrivilege(Enum<?> permissionEnum, int privilegeLevel, boolean allowSystem) {
        return AAA.hasPermissionOrPrivilege(permissionEnum, privilegeLevel, allowSystem, this);
    }

    public boolean hasPermissionOrPrivilege(Object GuardedResource, Permission permission, Privilege privilege) {
        return AAA.hasPermissionOrPrivilege(GuardedResource, permission, privilege, this);
    }

    public boolean hasPermissionOrPrivilege(Object guardedResource, String permissionName, String privilegeName) {
        return AAA.hasPermissionOrPrivilege(guardedResource, permissionName, privilegeName, this);
    }

    public boolean hasPermissionOrPrivilege(Object guardedResource, String permissionName, int privilegeLevel) {
        return AAA.hasPermissionOrPrivilege(guardedResource, permissionName, privilegeLevel, this);
    }

    public boolean hasPermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, Enum<?> privilegeEnum) {
        return AAA.hasPermissionOrPrivilege(guardedResource, permissionEnum, privilegeEnum, this);
    }

    public boolean hasPermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, int privilegeLevel) {
        return AAA.hasPermissionOrPrivilege(guardedResource, permissionEnum, privilegeLevel, this);
    }

    public boolean hasPermissionOrPrivilege(Object GuardedResource, Permission permission, Privilege privilege, boolean allowSystem) {
        return AAA.hasPermissionOrPrivilege(GuardedResource, permission, privilege, allowSystem, this);
    }

    public boolean hasPermissionOrPrivilege(Object guardedResource, String permissionName, String privilegeName, boolean allowSystem) {
        return AAA.hasPermissionOrPrivilege(guardedResource, permissionName, privilegeName, allowSystem, this);
    }

    public boolean hasPermissionOrPrivilege(Object guardedResource, String permissionName, int privilegeLevel, boolean allowSystem) {
        return AAA.hasPermissionOrPrivilege(guardedResource, permissionName, privilegeLevel, allowSystem, this);
    }

    public boolean hasPermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, Enum<?> privilegeEnum, boolean allowSystem) {
        return AAA.hasPermissionOrPrivilege(guardedResource, permissionEnum, privilegeEnum, allowSystem, this);
    }

    public boolean hasPermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, int privilegeLevel, boolean allowSystem) {
        return AAA.hasPermissionOrPrivilege(guardedResource, permissionEnum, privilegeLevel, allowSystem, this);
    }

    public void requirePermissionOrPrivilege(Permission permission, Privilege privilege) {
        AAA.requirePermissionOrPrivilege(permission, privilege, this);
    }

    public void requirePermissionOrPrivilege(String permissionName, String privilegeName) {
        AAA.requirePermissionOrPrivilege(permissionName, privilegeName, this);
    }

    public void requirePermissionOrPrivilege(String permissionName, int privilegeLevel) {
        AAA.requirePermissionOrPrivilege(permissionName, privilegeLevel, this);
    }

    public void requirePermissionOrPrivilege(Enum<?> permissionEnum, Enum<?> privilegeEnum) {
        AAA.requirePermissionOrPrivilege(permissionEnum, privilegeEnum, this);
    }

    public void requirePermissionOrPrivilege(Enum<?> permissionEnum, int privilegeLevel) {
        AAA.requirePermissionOrPrivilege(permissionEnum, privilegeLevel, this);
    }

    public void requirePermissionOrPrivilege(Permission permission, Privilege privilege, boolean allowSystem) {
        AAA.requirePermissionOrPrivilege(permission, privilege, allowSystem, this);
    }

    public void requirePermissionOrPrivilege(String permissionName, String privilegeName, boolean allowSystem) {
        AAA.requirePermissionOrPrivilege(permissionName, privilegeName, allowSystem, this);
    }

    public void requirePermissionOrPrivilege(String permissionName, int privilegeLevel, boolean allowSystem) {
        AAA.requirePermissionOrPrivilege(permissionName, privilegeLevel, allowSystem, this);
    }

    public void requirePermissionOrPrivilege(Enum<?> permissionEnum, Enum<?> privilegeEnum, boolean allowSystem) {
        AAA.requirePermissionOrPrivilege(permissionEnum, privilegeEnum, allowSystem, this);
    }

    public void requirePermissionOrPrivilege(Enum<?> permissionEnum, int privilegeLevel, boolean allowSystem) {
        AAA.requirePermissionOrPrivilege(permissionEnum, privilegeLevel, allowSystem, this);
    }

    public void requirePermissionOrPrivilege(Object GuardedResource, Permission permission, Privilege privilege) {
        AAA.requirePermissionOrPrivilege(GuardedResource, permission, privilege, this);
    }

    public void requirePermissionOrPrivilege(Object guardedResource, String permissionName, String privilegeName) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionName, privilegeName, this);
    }

    public void requirePermissionOrPrivilege(Object guardedResource, String permissionName, int privilegeLevel) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionName, privilegeLevel, this);
    }

    public void requirePermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, Enum<?> privilegeEnum) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionEnum, privilegeEnum, this);
    }

    public void requirePermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, int privilegeLevel) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionEnum, privilegeLevel, this);
    }

    public void requirePermissionOrPrivilege(Object GuardedResource, Permission permission, Privilege privilege, boolean allowSystem) {
        AAA.requirePermissionOrPrivilege(GuardedResource, permission, privilege, allowSystem, this);
    }

    public void requirePermissionOrPrivilege(Object guardedResource, String permissionName, String privilegeName, boolean allowSystem) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionName, privilegeName, allowSystem, this);
    }

    public void requirePermissionOrPrivilege(Object guardedResource, String permissionName, int privilegeLevel, boolean allowSystem) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionName, privilegeLevel, allowSystem, this);
    }

    public void requirePermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, Enum<?> privilegeEnum, boolean allowSystem) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionEnum, privilegeEnum, allowSystem, this);
    }

    public void requirePermissionOrPrivilege(Object guardedResource, Enum<?> permissionEnum, int privilegeLevel, boolean allowSystem) {
        AAA.requirePermissionOrPrivilege(guardedResource, permissionEnum, privilegeLevel, allowSystem, this);
    }
}

