/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.webapp.impl.util;

import jakarta.ws.rs.core.Response;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.rest.exception.RestException;
import org.operaton.bpm.engine.rest.spi.ProcessEngineProvider;

public final class ProcessEngineUtil {
    private ProcessEngineUtil() {
    }

    public static ProcessEngine lookupProcessEngine(String engineName) {
        ServiceLoader<ProcessEngineProvider> serviceLoader = ServiceLoader.load(ProcessEngineProvider.class);
        Iterator<ProcessEngineProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            ProcessEngineProvider provider = iterator.next();
            return provider.getProcessEngine(engineName);
        }
        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "Could not find an implementation of the " + String.valueOf(ProcessEngineProvider.class) + "- SPI");
    }
}

