/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.webapp.impl.security.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import org.operaton.bpm.webapp.impl.security.filter.CookieConfigurator;

public class SessionCookieFilter
implements Filter {
    protected CookieConfigurator cookieConfigurator = new CookieConfigurator();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.cookieConfigurator.parseParams(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            if (servletResponse instanceof HttpServletResponse) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
                httpServletRequest.getSession();
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)new SameSiteResponseProxy(httpServletResponse));
            }
        }
    }

    public void destroy() {
    }

    protected class SameSiteResponseProxy
    extends HttpServletResponseWrapper {
        protected HttpServletResponse response;

        public SameSiteResponseProxy(HttpServletResponse resp) {
            super(resp);
            this.response = resp;
        }

        public void sendError(int sc) throws IOException {
            this.appendSameSiteIfMissing();
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.appendSameSiteIfMissing();
            super.sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            this.appendSameSiteIfMissing();
            super.sendRedirect(location);
        }

        public PrintWriter getWriter() throws IOException {
            this.appendSameSiteIfMissing();
            return super.getWriter();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            this.appendSameSiteIfMissing();
            return super.getOutputStream();
        }

        protected void appendSameSiteIfMissing() {
            Collection cookieHeaders = this.response.getHeaders("Set-Cookie");
            boolean firstHeader = true;
            String cookieHeaderStart = SessionCookieFilter.this.cookieConfigurator.getCookieName("JSESSIONID") + "=";
            for (String cookieHeader : cookieHeaders) {
                if (cookieHeader.startsWith(cookieHeaderStart)) {
                    cookieHeader = SessionCookieFilter.this.cookieConfigurator.getConfig(cookieHeader);
                }
                if (firstHeader) {
                    this.response.setHeader("Set-Cookie", cookieHeader);
                    firstHeader = false;
                    continue;
                }
                this.response.addHeader("Set-Cookie", cookieHeader);
            }
        }
    }
}

