/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.webapp.impl.security;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.operaton.bpm.cockpit.Cockpit;
import org.operaton.bpm.engine.IdentityService;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.webapp.impl.security.auth.Authentication;
import org.operaton.bpm.webapp.impl.security.auth.Authentications;
import org.operaton.bpm.webapp.impl.security.auth.UserAuthentication;

public final class SecurityActions {
    private SecurityActions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithAuthentications(SecurityAction<T> action, Authentications authentications) throws IOException, ServletException {
        List<UserAuthentication> currentAuthentications = authentications.getAuthentications();
        try {
            for (Authentication authentication : currentAuthentications) {
                SecurityActions.authenticateProcessEngine(authentication);
            }
            Iterator<UserAuthentication> iterator = action.execute();
            return (T)iterator;
        }
        finally {
            for (Authentication authentication : currentAuthentications) {
                SecurityActions.clearAuthentication(authentication);
            }
        }
    }

    private static void clearAuthentication(Authentication authentication) {
        ProcessEngine processEngine = Cockpit.getProcessEngine(authentication.getProcessEngineName());
        if (processEngine != null) {
            processEngine.getIdentityService().clearAuthentication();
        }
    }

    private static void authenticateProcessEngine(Authentication authentication) {
        ProcessEngine processEngine = Cockpit.getProcessEngine(authentication.getProcessEngineName());
        if (processEngine != null) {
            String userId = authentication.getIdentityId();
            List<String> groupIds = null;
            List<String> tenantIds = null;
            if (authentication instanceof UserAuthentication) {
                UserAuthentication userAuthentication = (UserAuthentication)authentication;
                groupIds = userAuthentication.getGroupIds();
                tenantIds = userAuthentication.getTenantIds();
            }
            processEngine.getIdentityService().setAuthentication(userId, groupIds, tenantIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithoutAuthentication(SecurityAction<T> action, ProcessEngine processEngine) throws IOException, ServletException {
        IdentityService identityService = processEngine.getIdentityService();
        org.operaton.bpm.engine.impl.identity.Authentication currentAuth = identityService.getCurrentAuthentication();
        try {
            identityService.clearAuthentication();
            T t = action.execute();
            return t;
        }
        finally {
            identityService.setAuthentication(currentAuth);
        }
    }

    public static interface SecurityAction<T> {
        public T execute() throws IOException, ServletException;
    }
}

