/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.webapp.impl.engine;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.operaton.bpm.admin.Admin;
import org.operaton.bpm.admin.AdminRuntimeDelegate;
import org.operaton.bpm.cockpit.Cockpit;
import org.operaton.bpm.cockpit.CockpitRuntimeDelegate;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.rest.util.WebApplicationUtil;
import org.operaton.bpm.tasklist.Tasklist;
import org.operaton.bpm.tasklist.TasklistRuntimeDelegate;
import org.operaton.bpm.webapp.impl.IllegalWebAppConfigurationException;
import org.operaton.bpm.webapp.impl.filter.AbstractTemplateFilter;
import org.operaton.bpm.webapp.impl.security.SecurityActions;
import org.operaton.bpm.webapp.impl.util.ServletContextUtil;
import org.operaton.bpm.webapp.plugin.spi.AppPlugin;
import org.operaton.bpm.welcome.Welcome;
import org.operaton.bpm.welcome.WelcomeRuntimeDelegate;

public class ProcessEnginesFilter
extends AbstractTemplateFilter {
    protected static final String COCKPIT_APP_NAME = "cockpit";
    protected static final String ADMIN_APP_NAME = "admin";
    protected static final String TASKLIST_APP_NAME = "tasklist";
    protected static final String WELCOME_APP_NAME = "welcome";
    protected static final String DEFAULT_APP = "welcome";
    protected static final String INDEX_PAGE = "index.html";
    protected static final String SETUP_PAGE = "setup/";
    public static final String APP_ROOT_PLACEHOLDER = "$APP_ROOT";
    public static final String BASE_PLACEHOLDER = "$BASE";
    public static final String PLUGIN_DEPENDENCIES_PLACEHOLDER = "$PLUGIN_DEPENDENCIES";
    public static final String PLUGIN_PACKAGES_PLACEHOLDER = "$PLUGIN_PACKAGES";
    public static final String CSP_NONCE_PLACEHOLDER = "$CSP_NONCE";
    public static final Pattern APP_PREFIX_PATTERN = Pattern.compile("/app/(?:([\\w-]+?)/(?:(index\\.html|[\\w-]+)?/?([^?]*)?)?)?");
    protected final CockpitRuntimeDelegate cockpitRuntimeDelegate = Cockpit.getRuntimeDelegate();
    protected final AdminRuntimeDelegate adminRuntimeDelegate = Admin.getRuntimeDelegate();
    protected final TasklistRuntimeDelegate tasklistRuntimeDelegate = Tasklist.getRuntimeDelegate();
    protected final WelcomeRuntimeDelegate welcomeRuntimeDelegate = Welcome.getRuntimeDelegate();
    protected final String pluginPackageFormat;
    protected final String pluginDependencyFormat;

    public ProcessEnginesFilter() {
        this.pluginPackageFormat = "{ name: '%s-plugin-%s', location: '%s%s/api/%s/plugin/%s/static/app', main: 'plugin.js' }";
        this.pluginDependencyFormat = "{ ngModuleName: '%s.plugin.%s', requirePackageName: '%s-plugin-%s' }";
    }

    @Override
    protected void applyFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        Matcher uriMatcher;
        String contextPath = request.getContextPath();
        String requestUri = request.getRequestURI().substring(contextPath.length());
        ServletContext servletContext = request.getServletContext();
        String applicationPath = ServletContextUtil.getAppPath(servletContext);
        int applicationPathLength = applicationPath.length();
        if (applicationPathLength > 0) {
            requestUri = requestUri.substring(applicationPathLength);
        }
        if ((uriMatcher = APP_PREFIX_PATTERN.matcher(requestUri)).matches()) {
            String appName = uriMatcher.group(1);
            String engineName = uriMatcher.group(2);
            String pageUri = uriMatcher.group(3);
            if (INDEX_PAGE.equals(engineName)) {
                engineName = null;
            }
            if (pageUri == null || pageUri.isEmpty() || SETUP_PAGE.equals(pageUri)) {
                this.serveIndexPage(appName, engineName, pageUri, applicationPath, contextPath, request, response);
                return;
            }
            if (INDEX_PAGE.equals(pageUri)) {
                response.sendRedirect("%s%s/app/%s/%s/".formatted(contextPath, applicationPath, appName, engineName));
                return;
            }
            if (pageUri.endsWith(".html")) {
                this.serveTemplate(requestUri, appName, pageUri, applicationPath, request, response, chain);
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected void serveIndexPage(String appName, String engineName, String pageUri, String applicationPath, String contextPath, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (appName == null) {
            response.sendRedirect("%s%s/app/%s/%s/".formatted(contextPath, applicationPath, "welcome", this.getDefaultEngineName()));
        } else if (engineName == null) {
            response.sendRedirect("%s%s/app/%s/%s/".formatted(contextPath, applicationPath, appName, this.getDefaultEngineName()));
        } else {
            boolean setupPage = SETUP_PAGE.equals(pageUri);
            if (this.needsInitialUser(engineName)) {
                if (!setupPage) {
                    String setupPath = "%s%s/app/admin/%s/setup/#/setup";
                    response.sendRedirect(setupPath.formatted(contextPath, applicationPath, engineName));
                } else {
                    this.serveIndexPage(appName, engineName, applicationPath, contextPath, response, request.getServletContext());
                }
            } else if (!setupPage) {
                this.serveIndexPage(appName, engineName, applicationPath, contextPath, response, request.getServletContext());
            } else {
                response.sendRedirect("%s%s/app/%s/%s/".formatted(contextPath, applicationPath, appName, engineName));
            }
        }
    }

    protected String getDefaultEngineName() {
        CockpitRuntimeDelegate runtimeDelegate = Cockpit.getRuntimeDelegate();
        Set<String> processEngineNames = runtimeDelegate.getProcessEngineNames();
        if (processEngineNames.isEmpty()) {
            throw new IllegalWebAppConfigurationException("No process engine found. operaton Webapp cannot work without a process engine. ");
        }
        ProcessEngine defaultProcessEngine = runtimeDelegate.getDefaultProcessEngine();
        if (defaultProcessEngine != null) {
            return defaultProcessEngine.getName();
        }
        return processEngineNames.iterator().next();
    }

    protected void serveTemplate(String requestUri, String appName, String pageUri, String applicationPath, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.hasWebResource(requestUri)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            String cleanAppUri = "%s/app/%s/%s".formatted(applicationPath, appName, pageUri);
            if (this.hasWebResource(cleanAppUri)) {
                request.getRequestDispatcher(cleanAppUri).forward((ServletRequest)request, (ServletResponse)response);
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    protected boolean needsInitialUser(String engineName) throws IOException, ServletException {
        ProcessEngine processEngine = Cockpit.getProcessEngine(engineName);
        if (processEngine == null) {
            return false;
        }
        if (processEngine.getIdentityService().isReadOnly()) {
            return false;
        }
        return SecurityActions.runWithoutAuthentication(() -> processEngine.getIdentityService().createUserQuery().memberOfGroup("operaton-admin").count() == 0L, processEngine);
    }

    protected void serveIndexPage(String appName, String engineName, String applicationPath, String contextPath, HttpServletResponse response, ServletContext servletContext) throws IOException {
        this.setWebappInTelemetry(engineName, appName, servletContext);
        String data = this.getWebResourceContents("/app/" + appName + "/index.html");
        String cspNonce = (String)servletContext.getAttribute("org.operaton.bpm.csp.nonce");
        data = this.replacePlaceholder(data, appName, engineName, applicationPath, contextPath, cspNonce);
        response.setContentLength(data.getBytes(StandardCharsets.UTF_8).length);
        response.setContentType("text/html");
        response.getWriter().append(data);
    }

    protected void setWebappInTelemetry(String engineName, String appName, ServletContext servletContext) {
        if (!ServletContextUtil.isTelemetryDataSentAlready(appName, engineName, servletContext) && WebApplicationUtil.setWebapp((String)engineName, (String)appName)) {
            ServletContextUtil.setTelemetryDataSent(appName, engineName, servletContext);
        }
    }

    protected String replacePlaceholder(String data, String appName, String engineName, String applicationPath, String contextPath, String cspNonce) {
        return data.replace(APP_ROOT_PLACEHOLDER, contextPath + applicationPath).replace(BASE_PLACEHOLDER, "%s%s/app/%s/%s/".formatted(contextPath, applicationPath, appName, engineName)).replace(PLUGIN_PACKAGES_PLACEHOLDER, this.createPluginPackagesStr(appName, applicationPath, contextPath)).replace(PLUGIN_DEPENDENCIES_PLACEHOLDER, this.createPluginDependenciesStr(appName)).replace(CSP_NONCE_PLACEHOLDER, cspNonce == null ? "" : "nonce=\"%s\"".formatted(cspNonce));
    }

    protected <T extends AppPlugin> CharSequence createPluginPackagesStr(String appName, String applicationPath, String contextPath) {
        List<T> plugins = this.getPlugins(appName);
        StringBuilder builder = new StringBuilder();
        for (AppPlugin plugin : plugins) {
            if (!builder.isEmpty()) {
                builder.append(", ").append("\n");
            }
            String pluginId = plugin.getId();
            String definition = this.pluginPackageFormat.formatted(appName, pluginId, contextPath, applicationPath, appName, pluginId);
            builder.append(definition);
        }
        return "[" + String.valueOf(builder) + "]";
    }

    protected <T extends AppPlugin> CharSequence createPluginDependenciesStr(String appName) {
        List<T> plugins = this.getPlugins(appName);
        StringBuilder builder = new StringBuilder();
        for (AppPlugin plugin : plugins) {
            if (!builder.isEmpty()) {
                builder.append(", ").append("\n");
            }
            String pluginId = plugin.getId();
            String definition = this.pluginDependencyFormat.formatted(appName, pluginId, appName, pluginId);
            builder.append(definition);
        }
        return "[" + String.valueOf(builder) + "]";
    }

    protected <T extends AppPlugin> List<T> getPlugins(String appName) {
        if (COCKPIT_APP_NAME.equals(appName)) {
            return this.cockpitRuntimeDelegate.getAppPluginRegistry().getPlugins();
        }
        if (ADMIN_APP_NAME.equals(appName)) {
            return this.adminRuntimeDelegate.getAppPluginRegistry().getPlugins();
        }
        if (TASKLIST_APP_NAME.equals(appName)) {
            return this.tasklistRuntimeDelegate.getAppPluginRegistry().getPlugins();
        }
        if ("welcome".equals(appName)) {
            return this.welcomeRuntimeDelegate.getAppPluginRegistry().getPlugins();
        }
        return Collections.emptyList();
    }
}

