/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.admin.impl.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.operaton.bpm.engine.AuthorizationService;
import org.operaton.bpm.engine.IdentityService;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.authorization.Authorization;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Permissions;
import org.operaton.bpm.engine.authorization.Resource;
import org.operaton.bpm.engine.authorization.Resources;
import org.operaton.bpm.engine.identity.Group;
import org.operaton.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.operaton.bpm.engine.rest.dto.identity.UserDto;
import org.operaton.bpm.engine.rest.impl.UserRestServiceImpl;
import org.operaton.bpm.engine.rest.spi.ProcessEngineProvider;
import org.operaton.bpm.engine.rest.util.ProvidersUtil;
import org.operaton.bpm.webapp.impl.WebappLogger;
import org.operaton.bpm.webapp.impl.security.SecurityActions;

@Path(value="/setup/{engine}")
public class SetupResource {
    protected static final WebappLogger LOGGER = WebappLogger.INSTANCE;
    @Context
    protected Providers providers;

    @Path(value="/user/create")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void createInitialUser(@PathParam(value="engine") String processEngineName, UserDto user) throws IOException, ServletException {
        ProcessEngine processEngine = this.lookupProcessEngine(processEngineName);
        if (processEngine == null) {
            throw LOGGER.invalidRequestEngineNotFoundForName(processEngineName);
        }
        SecurityActions.runWithoutAuthentication(() -> {
            this.createInitialUserInternal(processEngineName, user, processEngine);
            return null;
        }, processEngine);
    }

    protected void createInitialUserInternal(String processEngineName, UserDto user, ProcessEngine processEngine) {
        ObjectMapper objectMapper = this.getObjectMapper();
        this.ensureSetupAvailable(processEngine);
        UserRestServiceImpl userRestServiceImpl = new UserRestServiceImpl(processEngineName, objectMapper);
        userRestServiceImpl.createUser(user);
        this.ensureOperatonAdminGroupExists(processEngine);
        processEngine.getIdentityService().createMembership(user.getProfile().getId(), "operaton-admin");
    }

    protected ObjectMapper getObjectMapper() {
        if (this.providers != null) {
            return (ObjectMapper)ProvidersUtil.resolveFromContext((Providers)this.providers, ObjectMapper.class, (MediaType)MediaType.APPLICATION_JSON_TYPE, this.getClass());
        }
        return null;
    }

    protected void ensureOperatonAdminGroupExists(ProcessEngine processEngine) {
        IdentityService identityService = processEngine.getIdentityService();
        AuthorizationService authorizationService = processEngine.getAuthorizationService();
        if (identityService.createGroupQuery().groupId("operaton-admin").count() == 0L) {
            Group operatonAdminGroup = identityService.newGroup("operaton-admin");
            operatonAdminGroup.setName("operaton BPM Administrators");
            operatonAdminGroup.setType("SYSTEM");
            identityService.saveGroup(operatonAdminGroup);
        }
        for (Resources resource : Resources.values()) {
            if (authorizationService.createAuthorizationQuery().groupIdIn(new String[]{"operaton-admin"}).resourceType((Resource)resource).resourceId("*").count() != 0L) continue;
            AuthorizationEntity userAdminAuth = new AuthorizationEntity(1);
            userAdminAuth.setGroupId("operaton-admin");
            userAdminAuth.setResource((Resource)resource);
            userAdminAuth.setResourceId("*");
            userAdminAuth.addPermission((Permission)Permissions.ALL);
            authorizationService.saveAuthorization((Authorization)userAdminAuth);
        }
    }

    protected void ensureSetupAvailable(ProcessEngine processEngine) {
        if (processEngine.getIdentityService().isReadOnly() || processEngine.getIdentityService().createUserQuery().memberOfGroup("operaton-admin").count() > 0L) {
            throw LOGGER.setupActionNotAvailable();
        }
    }

    protected ProcessEngine lookupProcessEngine(String engineName) {
        ServiceLoader<ProcessEngineProvider> serviceLoader = ServiceLoader.load(ProcessEngineProvider.class);
        Iterator<ProcessEngineProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            ProcessEngineProvider provider = iterator.next();
            return provider.getProcessEngine(engineName);
        }
        throw LOGGER.processEngineProviderNotFound();
    }
}

