/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.webapp.impl.security.filter.headersec.provider.impl;

import java.util.Map;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.webapp.impl.security.filter.headersec.provider.HeaderSecurityProvider;
import org.operaton.bpm.webapp.impl.security.filter.headersec.provider.impl.XssProtectionOption;
import org.operaton.bpm.webapp.impl.util.ServletFilterUtil;

public class XssProtectionProvider
extends HeaderSecurityProvider {
    public static final String HEADER_NAME = "X-XSS-Protection";
    public static final XssProtectionOption HEADER_DEFAULT_VALUE = XssProtectionOption.BLOCK;
    public static final String DISABLED_PARAM = "xssProtectionDisabled";
    public static final String OPTION_PARAM = "xssProtectionOption";
    public static final String VALUE_PARAM = "xssProtectionValue";

    public Map<String, String> initParams() {
        this.initParams.put(DISABLED_PARAM, null);
        this.initParams.put(OPTION_PARAM, null);
        this.initParams.put(VALUE_PARAM, null);
        return this.initParams;
    }

    public void parseParams() {
        String disabled = (String)this.initParams.get(DISABLED_PARAM);
        if (ServletFilterUtil.isEmpty((String)disabled)) {
            this.setDisabled(false);
        } else {
            this.setDisabled(Boolean.parseBoolean(disabled));
        }
        String value = (String)this.initParams.get(VALUE_PARAM);
        String option = (String)this.initParams.get(OPTION_PARAM);
        if (!this.isDisabled()) {
            if (!ServletFilterUtil.isEmpty((String)value) && !ServletFilterUtil.isEmpty((String)option)) {
                throw new ProcessEngineException(this.getClass().getSimpleName() + ": cannot set both xssProtectionValue and xssProtectionOption.");
            }
            if (!ServletFilterUtil.isEmpty((String)value)) {
                this.setValue(value);
            } else if (!ServletFilterUtil.isEmpty((String)option)) {
                this.setValue(this.parseValue(option).getHeaderValue());
            } else {
                this.setValue(HEADER_DEFAULT_VALUE.getHeaderValue());
            }
        }
    }

    protected XssProtectionOption parseValue(String optionValue) {
        for (XssProtectionOption option : XssProtectionOption.values()) {
            if (!option.getName().equalsIgnoreCase(optionValue)) continue;
            return option;
        }
        throw new ProcessEngineException(this.getClass().getSimpleName() + ": cannot set non-existing option " + optionValue + " for xssProtectionOption.");
    }

    public String getHeaderName() {
        return HEADER_NAME;
    }
}

