/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.webapp.impl.security.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.operaton.bpm.engine.impl.util.IoUtil;
import org.operaton.bpm.webapp.impl.security.auth.Authentications;
import org.operaton.bpm.webapp.impl.security.filter.Authorization;
import org.operaton.bpm.webapp.impl.security.filter.SecurityFilterRule;
import org.operaton.bpm.webapp.impl.security.filter.util.FilterRules;
import org.operaton.bpm.webapp.impl.util.ServletContextUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecurityFilter
implements Filter {
    public List<SecurityFilterRule> filterRules = new ArrayList();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilterSecure((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    public void doFilterSecure(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestUri = this.getRequestUri(request);
        Authorization authorization = SecurityFilter.authorize((String)request.getMethod(), (String)requestUri, (List)this.filterRules);
        authorization.attachHeaders(response);
        if (authorization.isGranted()) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else if (authorization.isAuthenticated()) {
            String application = authorization.getApplication();
            if (application != null) {
                this.sendForbiddenApplicationAccess(application, response);
            } else {
                this.sendForbidden(response);
            }
        } else {
            this.sendUnauthorized(response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        String applicationPath = ServletContextUtil.getAppPath((ServletContext)servletContext);
        this.loadFilterRules(filterConfig, applicationPath);
    }

    public void destroy() {
    }

    public static Authorization authorize(String requestMethod, String requestUri, List<SecurityFilterRule> filterRules) {
        return FilterRules.authorize((String)requestMethod, (String)requestUri, filterRules);
    }

    protected void loadFilterRules(FilterConfig filterConfig, String applicationPath) throws ServletException {
        String configFileName = filterConfig.getInitParameter("configFile");
        InputStream configFileResource = filterConfig.getServletContext().getResourceAsStream(configFileName);
        if (configFileResource == null) {
            throw new ServletException("Could not read security filter config file '" + configFileName + "': no such resource in servlet context.");
        }
        try {
            this.filterRules = FilterRules.load((InputStream)configFileResource, (String)applicationPath);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while parsing '" + configFileName + "'", e);
        }
        finally {
            IoUtil.closeSilently((Closeable)configFileResource);
        }
    }

    protected void sendForbidden(HttpServletResponse response) throws IOException {
        response.sendError(403);
    }

    protected void sendUnauthorized(HttpServletResponse response) throws IOException {
        response.sendError(401);
    }

    protected void sendForbiddenApplicationAccess(String application, HttpServletResponse response) throws IOException {
        response.sendError(403, "No access rights for " + application);
    }

    protected boolean isAuthenticated() {
        return Authentications.getCurrent() != null;
    }

    protected String getRequestUri(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        return request.getRequestURI().substring(contextPath.length());
    }
}

