/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.webapp.impl.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.operaton.commons.utils.IoUtil;

public abstract class AbstractTemplateFilter
implements Filter {
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.applyFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    protected abstract void applyFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    protected boolean hasWebResource(String name) {
        try {
            URL resource = this.filterConfig.getServletContext().getResource(name);
            return resource != null;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    protected String getWebResourceContents(String name) throws IOException {
        try (InputStream is = this.filterConfig.getServletContext().getResourceAsStream(name);){
            if (is == null) {
                throw new IOException("Resource not found: " + name);
            }
            String string = IoUtil.inputStreamAsString((InputStream)is);
            return string;
        }
    }
}

