/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.cockpit.impl.plugin.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import org.operaton.bpm.cockpit.db.QueryParameters;
import org.operaton.bpm.cockpit.db.QueryService;
import org.operaton.bpm.cockpit.impl.plugin.base.dto.ProcessInstanceDto;
import org.operaton.bpm.cockpit.impl.plugin.base.dto.query.ProcessInstanceQueryDto;
import org.operaton.bpm.cockpit.impl.plugin.base.sub.resources.ProcessInstanceResource;
import org.operaton.bpm.cockpit.impl.plugin.resources.ProcessInstanceRestService;
import org.operaton.bpm.cockpit.plugin.resource.AbstractPluginResource;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Permissions;
import org.operaton.bpm.engine.authorization.Resource;
import org.operaton.bpm.engine.authorization.Resources;
import org.operaton.bpm.engine.impl.ProcessEngineImpl;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.history.HistoryLevel;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.rest.dto.CountResultDto;

public class ProcessInstanceRestService
extends AbstractPluginResource {
    public static final String PATH = "/process-instance";
    protected ObjectMapper objectMapper;

    public ProcessInstanceRestService(String engineName) {
        super(engineName);
    }

    @Path(value="/{id}")
    public ProcessInstanceResource getProcessInstance(@PathParam(value="id") String id) {
        return new ProcessInstanceResource(this.getProcessEngine().getName(), id);
    }

    @GET
    @Produces(value={"application/json"})
    public List<ProcessInstanceDto> getProcessInstances(@Context UriInfo uriInfo, @QueryParam(value="firstResult") Integer firstResult, @QueryParam(value="maxResults") Integer maxResults) {
        ProcessInstanceQueryDto queryParameter = new ProcessInstanceQueryDto(uriInfo.getQueryParameters());
        return this.queryProcessInstances(queryParameter, firstResult, maxResults);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<ProcessInstanceDto> queryProcessInstances(ProcessInstanceQueryDto queryParameter, @QueryParam(value="firstResult") Integer firstResult, @QueryParam(value="maxResults") Integer maxResults) {
        return (List)this.getCommandExecutor().executeCommand((Command)new QueryProcessInstancesCmd(this, queryParameter, firstResult, maxResults));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/count")
    public CountResultDto getProcessInstancesCount(@Context UriInfo uriInfo) {
        ProcessInstanceQueryDto queryParameter = new ProcessInstanceQueryDto(uriInfo.getQueryParameters());
        return this.queryProcessInstancesCount(queryParameter);
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/count")
    public CountResultDto queryProcessInstancesCount(ProcessInstanceQueryDto queryParameter) {
        return (CountResultDto)this.getCommandExecutor().executeCommand((Command)new QueryProcessInstancesCountCmd(this, queryParameter));
    }

    private void injectEngineConfig(ProcessInstanceQueryDto parameter) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)this.getProcessEngine()).getProcessEngineConfiguration();
        if (processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_NONE)) {
            parameter.setHistoryEnabled(false);
        }
        parameter.initQueryVariableValues(processEngineConfiguration.getVariableSerializers(), processEngineConfiguration.getDatabaseType());
    }

    protected void configureExecutionQuery(ProcessInstanceQueryDto query) {
        this.configureAuthorizationCheck((QueryParameters)query);
        this.configureTenantCheck((QueryParameters)query);
        this.addPermissionCheck((QueryParameters)query, (Resource)Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", (Permission)Permissions.READ);
        this.addPermissionCheck((QueryParameters)query, (Resource)Resources.PROCESS_DEFINITION, "P.KEY_", (Permission)Permissions.READ_INSTANCE);
    }

    protected void injectObjectMapper(ProcessInstanceQueryDto queryParameter) {
        queryParameter.setObjectMapper(this.objectMapper);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    static /* synthetic */ QueryService access$000(ProcessInstanceRestService x0) {
        return x0.getQueryService();
    }

    static /* synthetic */ QueryService access$100(ProcessInstanceRestService x0) {
        return x0.getQueryService();
    }
}

