/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.cockpit.impl.plugin.base.dto.query;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import org.operaton.bpm.cockpit.impl.plugin.base.dto.ProcessDefinitionDto;
import org.operaton.bpm.cockpit.rest.dto.AbstractRestQueryParametersDto;
import org.operaton.bpm.engine.impl.QueryVariableValue;
import org.operaton.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.operaton.bpm.engine.rest.dto.ConditionQueryParameterDto;
import org.operaton.bpm.engine.rest.dto.OperatonQueryParam;
import org.operaton.bpm.engine.rest.dto.VariableQueryParameterDto;
import org.operaton.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.operaton.bpm.engine.rest.dto.converter.VariableListConverter;

public class ProcessDefinitionQueryDto
extends AbstractRestQueryParametersDto<ProcessDefinitionDto> {
    private static final long serialVersionUID = 1L;
    protected String parentProcessDefinitionId;
    protected String superProcessDefinitionId;
    protected String[] activityIdIn;
    protected String businessKey;
    private List<VariableQueryParameterDto> variables;
    private List<QueryVariableValue> queryVariableValues;

    public ProcessDefinitionQueryDto() {
    }

    public ProcessDefinitionQueryDto(MultivaluedMap<String, String> queryParameters) {
        super(queryParameters);
    }

    public String getParentProcessDefinitionId() {
        return this.parentProcessDefinitionId;
    }

    @OperatonQueryParam(value="parentProcessDefinitionId")
    public void setParentProcessDefinitionId(String parentProcessDefinitionId) {
        this.parentProcessDefinitionId = parentProcessDefinitionId;
    }

    public String getSuperProcessDefinitionId() {
        return this.superProcessDefinitionId;
    }

    @OperatonQueryParam(value="superProcessDefinitionId")
    public void setSuperProcessDefinitionId(String superProcessDefinitionId) {
        this.superProcessDefinitionId = superProcessDefinitionId;
    }

    public String[] getActivityIdIn() {
        return this.activityIdIn;
    }

    @OperatonQueryParam(value="activityIdIn", converter=StringArrayConverter.class)
    public void setActivityIdIn(String[] activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    @OperatonQueryParam(value="businessKey")
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @OperatonQueryParam(value="variables", converter=VariableListConverter.class)
    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    public List<QueryVariableValue> getQueryVariableValues() {
        return this.queryVariableValues;
    }

    public void initQueryVariableValues(VariableSerializers variableTypes, String dbType) {
        this.queryVariableValues = this.createQueryVariableValues(variableTypes, this.variables, dbType);
    }

    protected String getOrderByValue(String sortBy) {
        return super.getOrderBy();
    }

    protected boolean isValidSortByValue(String value) {
        return false;
    }

    private List<QueryVariableValue> createQueryVariableValues(VariableSerializers variableTypes, List<VariableQueryParameterDto> variables, String dbType) {
        ArrayList<QueryVariableValue> values = new ArrayList<QueryVariableValue>();
        if (variables == null) {
            return values;
        }
        for (VariableQueryParameterDto variable : variables) {
            QueryVariableValue value = new QueryVariableValue(variable.getName(), this.resolveVariableValue(variable.getValue()), ConditionQueryParameterDto.getQueryOperator((String)variable.getOperator()), false);
            value.initialize(variableTypes, dbType);
            values.add(value);
        }
        return values;
    }
}

