/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.spring.boot.starter.event;

import org.operaton.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.operaton.bpm.spring.boot.starter.event.PublishDelegateParseListener;
import org.operaton.bpm.spring.boot.starter.event.PublishHistoryEventHandler;
import org.operaton.bpm.spring.boot.starter.property.EventingProperty;
import org.operaton.bpm.spring.boot.starter.property.OperatonBpmProperties;
import org.operaton.bpm.spring.boot.starter.util.SpringBootProcessEnginePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class EventPublisherPlugin
extends SpringBootProcessEnginePlugin {
    private static final Logger logger = LoggerFactory.getLogger(EventPublisherPlugin.class);
    private final EventingProperty property;
    private final ApplicationEventPublisher publisher;

    public EventPublisherPlugin(OperatonBpmProperties properties, ApplicationEventPublisher publisher) {
        this(properties.getEventing(), publisher);
    }

    public EventPublisherPlugin(EventingProperty property, ApplicationEventPublisher publisher) {
        this.property = property;
        this.publisher = publisher;
    }

    @Override
    public void preInit(SpringProcessEngineConfiguration processEngineConfiguration) {
        if (Boolean.FALSE.equals(this.property.isTask()) && !this.property.isExecution() && Boolean.FALSE.equals(this.property.isHistory())) {
            logger.info("EVENTING-002: Operaton Spring Boot Eventing Plugin is found, but disabled via property.");
            return;
        }
        if (this.property.isTask().booleanValue() || this.property.isExecution()) {
            logger.info("EVENTING-001: Initialized Operaton Spring Boot Eventing Engine Plugin.");
            if (Boolean.TRUE.equals(this.property.isTask())) {
                logger.info("EVENTING-003: Task events will be published as Spring Events.");
            } else {
                logger.info("EVENTING-004: Task eventing is disabled via property.");
            }
            if (this.property.isExecution()) {
                logger.info("EVENTING-005: Execution events will be published as Spring Events.");
            } else {
                logger.info("EVENTING-006: Execution eventing is disabled via property.");
            }
            if (this.property.isSkippable()) {
                logger.info("EVENTING-009: Listeners will not be invoked if a skipCustomListeners API parameter is set to true by user.");
            } else {
                logger.info("EVENTING-009: Listeners will always be invoked regardless of skipCustomListeners API parameters.");
            }
            processEngineConfiguration.getCustomPostBPMNParseListeners().add(new PublishDelegateParseListener(this.publisher, this.property));
        }
        if (Boolean.TRUE.equals(this.property.isHistory())) {
            logger.info("EVENTING-007: History events will be published as Spring events.");
            processEngineConfiguration.getCustomHistoryEventHandlers().add(new PublishHistoryEventHandler(this.publisher));
        } else {
            logger.info("EVENTING-008: History eventing is disabled via property.");
        }
    }
}

