/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.spring.boot.starter.configuration.impl;

import java.util.Optional;
import org.operaton.bpm.engine.impl.cfg.IdGenerator;
import org.operaton.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.operaton.bpm.spring.boot.starter.configuration.OperatonProcessEngineConfiguration;
import org.operaton.bpm.spring.boot.starter.configuration.impl.AbstractOperatonConfiguration;
import org.operaton.bpm.spring.boot.starter.property.OperatonBpmProperties;
import org.springframework.util.StringUtils;

public class DefaultProcessEngineConfiguration
extends AbstractOperatonConfiguration
implements OperatonProcessEngineConfiguration {
    private final Optional<IdGenerator> idGenerator;

    public DefaultProcessEngineConfiguration(OperatonBpmProperties operatonBpmProperties, Optional<IdGenerator> idGenerator) {
        super(operatonBpmProperties);
        this.idGenerator = idGenerator;
    }

    @Override
    public void preInit(SpringProcessEngineConfiguration configuration) {
        this.setProcessEngineName(configuration);
        this.setDefaultSerializationFormat(configuration);
        this.setIdGenerator(configuration);
        this.setJobExecutorAcquireByPriority(configuration);
        this.setDefaultNumberOfRetries(configuration);
    }

    private void setIdGenerator(SpringProcessEngineConfiguration configuration) {
        this.idGenerator.ifPresent(arg_0 -> ((SpringProcessEngineConfiguration)configuration).setIdGenerator(arg_0));
    }

    private void setDefaultSerializationFormat(SpringProcessEngineConfiguration configuration) {
        String defaultSerializationFormat = this.operatonBpmProperties.getDefaultSerializationFormat();
        if (StringUtils.hasText((String)defaultSerializationFormat)) {
            configuration.setDefaultSerializationFormat(defaultSerializationFormat);
        } else {
            this.logger.warn("Ignoring invalid defaultSerializationFormat='{}'", (Object)defaultSerializationFormat);
        }
    }

    private void setProcessEngineName(SpringProcessEngineConfiguration configuration) {
        String processEngineName = StringUtils.trimAllWhitespace((String)this.operatonBpmProperties.getProcessEngineName());
        if (StringUtils.hasText((String)processEngineName) && !processEngineName.contains("-")) {
            if (Boolean.TRUE.equals(this.operatonBpmProperties.getGenerateUniqueProcessEngineName())) {
                if (!"default".equals(processEngineName)) {
                    throw new RuntimeException("A unique processEngineName cannot be generated if a custom processEngineName is already set: %s".formatted(processEngineName));
                }
                processEngineName = OperatonBpmProperties.getUniqueName("processEngine");
            }
            configuration.setProcessEngineName(processEngineName);
        } else {
            this.logger.warn("Ignoring invalid processEngineName='{}' - must not be null, blank or contain hyphen", (Object)this.operatonBpmProperties.getProcessEngineName());
        }
    }

    private void setJobExecutorAcquireByPriority(SpringProcessEngineConfiguration configuration) {
        Optional.ofNullable(this.operatonBpmProperties.getJobExecutorAcquireByPriority()).ifPresent(arg_0 -> ((SpringProcessEngineConfiguration)configuration).setJobExecutorAcquireByPriority(arg_0));
    }

    private void setDefaultNumberOfRetries(SpringProcessEngineConfiguration configuration) {
        Optional.ofNullable(this.operatonBpmProperties.getDefaultNumberOfRetries()).ifPresent(arg_0 -> ((SpringProcessEngineConfiguration)configuration).setDefaultNumberOfRetries(arg_0));
    }
}

