/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.spring.boot.starter.configuration.impl;

import java.util.List;
import java.util.Optional;
import org.operaton.bpm.engine.impl.jobexecutor.JobExecutor;
import org.operaton.bpm.engine.impl.jobexecutor.JobHandler;
import org.operaton.bpm.engine.impl.jobexecutor.NotifyAcquisitionRejectedJobsHandler;
import org.operaton.bpm.engine.impl.jobexecutor.RejectedJobsHandler;
import org.operaton.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.operaton.bpm.engine.spring.components.jobexecutor.SpringJobExecutor;
import org.operaton.bpm.spring.boot.starter.configuration.OperatonJobConfiguration;
import org.operaton.bpm.spring.boot.starter.configuration.impl.AbstractOperatonConfiguration;
import org.operaton.bpm.spring.boot.starter.event.JobExecutorStartingEventListener;
import org.operaton.bpm.spring.boot.starter.property.JobExecutionProperty;
import org.operaton.bpm.spring.boot.starter.property.OperatonBpmProperties;
import org.operaton.bpm.spring.boot.starter.util.OperatonSpringBootUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class DefaultJobConfiguration
extends AbstractOperatonConfiguration
implements OperatonJobConfiguration {
    protected JobExecutor jobExecutor;
    protected List<JobHandler<?>> customJobHandlers;

    public DefaultJobConfiguration(OperatonBpmProperties operatonBpmProperties, JobExecutor jobExecutor) {
        super(operatonBpmProperties);
        this.jobExecutor = jobExecutor;
    }

    @Override
    public void preInit(SpringProcessEngineConfiguration configuration) {
        this.configureJobExecutor(configuration);
        this.registerCustomJobHandlers(configuration);
    }

    @Autowired(required=false)
    public void setCustomJobHandlers(List<JobHandler<?>> customJobHandlers) {
        this.customJobHandlers = customJobHandlers;
    }

    protected void registerCustomJobHandlers(SpringProcessEngineConfiguration configuration) {
        configuration.setCustomJobHandlers(OperatonSpringBootUtil.join(configuration.getCustomJobHandlers(), this.customJobHandlers));
        for (JobHandler jobHandler : configuration.getCustomJobHandlers()) {
            this.logger.info("Register Custom JobHandler: '{}'", (Object)jobHandler.getType());
        }
    }

    protected void configureJobExecutor(SpringProcessEngineConfiguration configuration) {
        configuration.setJobExecutorActivate(false);
        configuration.setJobExecutorDeploymentAware(this.operatonBpmProperties.getJobExecution().isDeploymentAware());
        configuration.setJobExecutor(this.jobExecutor);
    }

    public static final class JobConfiguration {
        public static final String OPERATON_TASK_EXECUTOR_QUALIFIER = "operatonTaskExecutor";

        @Bean(name={"operatonTaskExecutor"})
        @ConditionalOnMissingBean(name={"operatonTaskExecutor"})
        @ConditionalOnProperty(prefix="operaton.bpm.job-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public static TaskExecutor operatonTaskExecutor(OperatonBpmProperties properties) {
            int corePoolSize = properties.getJobExecution().getCorePoolSize();
            int maxPoolSize = properties.getJobExecution().getMaxPoolSize();
            int queueCapacity = properties.getJobExecution().getQueueCapacity();
            ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
            threadPoolTaskExecutor.setCorePoolSize(corePoolSize);
            threadPoolTaskExecutor.setMaxPoolSize(maxPoolSize);
            threadPoolTaskExecutor.setQueueCapacity(queueCapacity);
            Optional.ofNullable(properties.getJobExecution().getKeepAliveSeconds()).ifPresent(arg_0 -> ((ThreadPoolTaskExecutor)threadPoolTaskExecutor).setKeepAliveSeconds(arg_0));
            AbstractOperatonConfiguration.LOG.configureJobExecutorPool(corePoolSize, maxPoolSize);
            return threadPoolTaskExecutor;
        }

        @Bean
        @ConditionalOnMissingBean(value={JobExecutor.class})
        @ConditionalOnProperty(prefix="operaton.bpm.job-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public static JobExecutor jobExecutor(@Qualifier(value="operatonTaskExecutor") TaskExecutor taskExecutor, OperatonBpmProperties properties) {
            SpringJobExecutor springJobExecutor = new SpringJobExecutor();
            springJobExecutor.setTaskExecutor(taskExecutor);
            springJobExecutor.setRejectedJobsHandler((RejectedJobsHandler)new NotifyAcquisitionRejectedJobsHandler());
            JobExecutionProperty jobExecution = properties.getJobExecution();
            Optional.ofNullable(jobExecution.getLockTimeInMillis()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setLockTimeInMillis(arg_0));
            Optional.ofNullable(jobExecution.getMaxJobsPerAcquisition()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setMaxJobsPerAcquisition(arg_0));
            Optional.ofNullable(jobExecution.getWaitTimeInMillis()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setWaitTimeInMillis(arg_0));
            Optional.ofNullable(jobExecution.getMaxWait()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setMaxWait(arg_0));
            Optional.ofNullable(jobExecution.getBackoffTimeInMillis()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setBackoffTimeInMillis(arg_0));
            Optional.ofNullable(jobExecution.getMaxBackoff()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setMaxBackoff(arg_0));
            Optional.ofNullable(jobExecution.getBackoffDecreaseThreshold()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setBackoffDecreaseThreshold(arg_0));
            Optional.ofNullable(jobExecution.getWaitIncreaseFactor()).ifPresent(arg_0 -> ((SpringJobExecutor)springJobExecutor).setWaitIncreaseFactor(arg_0));
            return springJobExecutor;
        }

        @Bean
        @ConditionalOnProperty(prefix="operaton.bpm.job-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
        @ConditionalOnBean(value={JobExecutor.class})
        public static JobExecutorStartingEventListener jobExecutorStartingEventListener(JobExecutor jobExecutor) {
            return new JobExecutorStartingEventListener(jobExecutor);
        }

        private JobConfiguration() {
        }
    }
}

