/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.variable.serializer;

import java.io.InputStream;
import org.operaton.bpm.engine.impl.util.IoUtil;
import org.operaton.bpm.engine.impl.variable.serializer.PrimitiveValueSerializer;
import org.operaton.bpm.engine.impl.variable.serializer.ValueFields;
import org.operaton.bpm.engine.variable.Variables;
import org.operaton.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.operaton.bpm.engine.variable.type.ValueType;
import org.operaton.bpm.engine.variable.value.BytesValue;
import org.operaton.bpm.engine.variable.value.TypedValue;

public class ByteArrayValueSerializer
extends PrimitiveValueSerializer<BytesValue> {
    public ByteArrayValueSerializer() {
        super(ValueType.BYTES);
    }

    @Override
    public BytesValue convertToTypedValue(UntypedValueImpl untypedValue) {
        Object value = untypedValue.getValue();
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return Variables.byteArrayValue((byte[])bytes, (boolean)untypedValue.isTransient());
        }
        byte[] data = IoUtil.readInputStream((InputStream)value, null);
        return Variables.byteArrayValue((byte[])data, (boolean)untypedValue.isTransient());
    }

    @Override
    public BytesValue readValue(ValueFields valueFields, boolean asTransientValue) {
        return Variables.byteArrayValue((byte[])valueFields.getByteArrayValue(), (boolean)asTransientValue);
    }

    @Override
    public void writeValue(BytesValue variableValue, ValueFields valueFields) {
        valueFields.setByteArrayValue((byte[])variableValue.getValue());
    }

    @Override
    protected boolean canWriteValue(TypedValue typedValue) {
        return super.canWriteValue(typedValue) || typedValue.getValue() instanceof InputStream;
    }
}

