/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.variable.serializer;

import org.operaton.bpm.engine.impl.variable.serializer.PrimitiveValueSerializer;
import org.operaton.bpm.engine.impl.variable.serializer.ValueFields;
import org.operaton.bpm.engine.variable.Variables;
import org.operaton.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.operaton.bpm.engine.variable.type.ValueType;
import org.operaton.bpm.engine.variable.value.BooleanValue;

public class BooleanValueSerializer
extends PrimitiveValueSerializer<BooleanValue> {
    private static final Long TRUE = 1L;
    private static final Long FALSE = 0L;

    public BooleanValueSerializer() {
        super(ValueType.BOOLEAN);
    }

    @Override
    public BooleanValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return Variables.booleanValue((Boolean)((Boolean)untypedValue.getValue()), (boolean)untypedValue.isTransient());
    }

    @Override
    public BooleanValue readValue(ValueFields valueFields, boolean asTransientValue) {
        Boolean boolValue = null;
        Long longValue = valueFields.getLongValue();
        if (longValue != null) {
            boolValue = longValue.equals(TRUE);
        }
        return Variables.booleanValue(boolValue, (boolean)asTransientValue);
    }

    @Override
    public void writeValue(BooleanValue variableValue, ValueFields valueFields) {
        Long longValue = null;
        Boolean boolValue = (Boolean)variableValue.getValue();
        if (boolValue != null) {
            longValue = Boolean.TRUE.equals(boolValue) ? TRUE : FALSE;
        }
        valueFields.setLongValue(longValue);
    }
}

