/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.variable.serializer;

import java.util.Base64;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.util.StringUtil;
import org.operaton.bpm.engine.impl.variable.serializer.AbstractTypedValueSerializer;
import org.operaton.bpm.engine.impl.variable.serializer.ValueFields;
import org.operaton.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.operaton.bpm.engine.variable.type.SerializableValueType;
import org.operaton.bpm.engine.variable.type.ValueType;
import org.operaton.bpm.engine.variable.value.SerializableValue;
import org.operaton.bpm.engine.variable.value.TypedValue;

public abstract class AbstractSerializableValueSerializer<T extends SerializableValue>
extends AbstractTypedValueSerializer<T> {
    protected String serializationDataFormat;

    protected AbstractSerializableValueSerializer(SerializableValueType type, String serializationDataFormat) {
        super((ValueType)type);
        this.serializationDataFormat = serializationDataFormat;
    }

    @Override
    public String getSerializationDataformat() {
        return this.serializationDataFormat;
    }

    @Override
    public void writeValue(T value, ValueFields valueFields) {
        String serializedStringValue = value.getValueSerialized();
        byte[] serializedByteValue = null;
        if (value.isDeserialized()) {
            Object objectToSerialize = value.getValue();
            if (objectToSerialize != null) {
                try {
                    serializedByteValue = this.serializeToByteArray(objectToSerialize);
                    serializedStringValue = this.getSerializedStringValue(serializedByteValue);
                }
                catch (Exception e) {
                    throw new ProcessEngineException("Cannot serialize object in variable '" + valueFields.getName() + "': " + e.getMessage(), e);
                }
            }
        } else if (serializedStringValue != null) {
            serializedByteValue = this.getSerializedBytesValue(serializedStringValue);
        }
        this.writeToValueFields(value, valueFields, serializedByteValue);
        this.updateTypedValue(value, serializedStringValue);
    }

    @Override
    public T readValue(ValueFields valueFields, boolean deserializeObjectValue, boolean asTransientValue) {
        byte[] serializedByteValue = this.readSerializedValueFromFields(valueFields);
        String serializedStringValue = this.getSerializedStringValue(serializedByteValue);
        if (deserializeObjectValue) {
            Object deserializedObject = null;
            if (serializedByteValue != null) {
                try {
                    deserializedObject = this.deserializeFromByteArray(serializedByteValue, valueFields);
                }
                catch (Exception e) {
                    throw new ProcessEngineException("Cannot deserialize object in variable '" + valueFields.getName() + "': " + e.getMessage(), e);
                }
            }
            return this.createDeserializedValue(deserializedObject, serializedStringValue, valueFields, asTransientValue);
        }
        return this.createSerializedValue(serializedStringValue, valueFields, asTransientValue);
    }

    protected abstract T createDeserializedValue(Object var1, String var2, ValueFields var3, boolean var4);

    protected abstract T createSerializedValue(String var1, ValueFields var2, boolean var3);

    protected abstract void writeToValueFields(T var1, ValueFields var2, byte[] var3);

    protected abstract void updateTypedValue(T var1, String var2);

    protected byte[] readSerializedValueFromFields(ValueFields valueFields) {
        return valueFields.getByteArrayValue();
    }

    protected String getSerializedStringValue(byte[] serializedByteValue) {
        if (serializedByteValue != null) {
            if (!this.isSerializationTextBased()) {
                serializedByteValue = Base64.getEncoder().encode(serializedByteValue);
            }
            return StringUtil.fromBytes(serializedByteValue);
        }
        return null;
    }

    protected byte[] getSerializedBytesValue(String serializedStringValue) {
        if (serializedStringValue != null) {
            byte[] serializedByteValue = StringUtil.toByteArray(serializedStringValue);
            if (!this.isSerializationTextBased()) {
                serializedByteValue = Base64.getDecoder().decode(serializedByteValue);
            }
            return serializedByteValue;
        }
        return null;
    }

    @Override
    protected boolean canWriteValue(TypedValue typedValue) {
        if (!(typedValue instanceof SerializableValue) && !(typedValue instanceof UntypedValueImpl)) {
            return false;
        }
        if (typedValue instanceof SerializableValue) {
            SerializableValue serializableValue = (SerializableValue)typedValue;
            String requestedDataFormat = serializableValue.getSerializationDataFormat();
            if (!serializableValue.isDeserialized()) {
                return this.serializationDataFormat.equals(requestedDataFormat);
            }
            boolean canSerialize = typedValue.getValue() == null || this.canSerializeValue(typedValue.getValue());
            return canSerialize && (requestedDataFormat == null || this.serializationDataFormat.equals(requestedDataFormat));
        }
        return typedValue.getValue() == null || this.canSerializeValue(typedValue.getValue());
    }

    protected abstract boolean canSerializeValue(Object var1);

    protected abstract byte[] serializeToByteArray(Object var1) throws Exception;

    protected abstract Object deserializeFromByteArray(byte[] var1, ValueFields var2) throws Exception;

    protected abstract boolean isSerializationTextBased();
}

