/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.util;

import org.operaton.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.operaton.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.operaton.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.operaton.bpm.engine.impl.pvm.PvmException;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public final class ActivityBehaviorUtil {
    private ActivityBehaviorUtil() {
    }

    public static CmmnActivityBehavior getActivityBehavior(CmmnExecution execution) {
        String id = execution.getId();
        CmmnActivity activity = execution.getActivity();
        EnsureUtil.ensureNotNull(PvmException.class, "Case execution '" + id + "' has no current activity.", "activity", (Object)activity);
        CmmnActivityBehavior behavior = activity.getActivityBehavior();
        EnsureUtil.ensureNotNull(PvmException.class, "There is no behavior specified in " + String.valueOf(activity) + " for case execution '" + id + "'.", "behavior", (Object)behavior);
        return behavior;
    }

    public static ActivityBehavior getActivityBehavior(PvmExecutionImpl execution) {
        String id = execution.getId();
        ActivityImpl activity = execution.getActivity();
        EnsureUtil.ensureNotNull(PvmException.class, "Execution '" + id + "' has no current activity.", "activity", (Object)activity);
        ActivityBehavior behavior = activity.getActivityBehavior();
        EnsureUtil.ensureNotNull(PvmException.class, "There is no behavior specified in " + String.valueOf(activity) + " for execution '" + id + "'.", "behavior", (Object)behavior);
        return behavior;
    }
}

