/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.test;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.operaton.bpm.engine.HistoryService;
import org.operaton.bpm.engine.ManagementService;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.ProcessEngineConfiguration;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.ProcessEngines;
import org.operaton.bpm.engine.history.UserOperationLogEntry;
import org.operaton.bpm.engine.impl.HistoryLevelSetupCommand;
import org.operaton.bpm.engine.impl.ManagementServiceImpl;
import org.operaton.bpm.engine.impl.ProcessEngineImpl;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.application.ProcessApplicationManager;
import org.operaton.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.operaton.bpm.engine.impl.cfg.IdGenerator;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.cmmn.behavior.CaseControlRuleImpl;
import org.operaton.bpm.engine.impl.cmmn.deployer.CmmnDeployer;
import org.operaton.bpm.engine.impl.db.DbIdGenerator;
import org.operaton.bpm.engine.impl.db.PersistenceSession;
import org.operaton.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.operaton.bpm.engine.impl.dmn.deployer.DecisionDefinitionDeployer;
import org.operaton.bpm.engine.impl.el.FixedValue;
import org.operaton.bpm.engine.impl.history.HistoryLevel;
import org.operaton.bpm.engine.impl.management.DatabasePurgeReport;
import org.operaton.bpm.engine.impl.management.PurgeReport;
import org.operaton.bpm.engine.impl.persistence.deploy.cache.CachePurgeReport;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.operaton.bpm.engine.impl.test.ProcessEngineAssert;
import org.operaton.bpm.engine.impl.test.RequiredDatabase;
import org.operaton.bpm.engine.impl.util.ClassNameUtil;
import org.operaton.bpm.engine.impl.util.ReflectUtil;
import org.operaton.bpm.engine.repository.DeploymentBuilder;
import org.operaton.bpm.engine.test.Deployment;
import org.operaton.bpm.engine.test.RequiredHistoryLevel;
import org.slf4j.Logger;

public abstract class TestHelper {
    private static final Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    public static final String EMPTY_LINE = "                                                                                           ";
    public static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = Arrays.asList("ACT_GE_PROPERTY", "ACT_GE_SCHEMA_LOG");
    public static final List<String> RESOURCE_SUFFIXES = new ArrayList<String>();

    @Deprecated(forRemoval=true, since="1.0")
    public static void assertProcessEnded(ProcessEngine processEngine, String processInstanceId) {
        ProcessEngineAssert.assertProcessEnded(processEngine, processInstanceId);
    }

    public static String annotationDeploymentSetUp(ProcessEngine processEngine, Class<?> testClass, String methodName, Deployment deploymentAnnotation, Class<?> ... parameterTypes) {
        boolean onMethod;
        Method method;
        block6: {
            method = null;
            onMethod = true;
            try {
                method = TestHelper.getMethod(testClass, methodName, parameterTypes);
            }
            catch (Exception e) {
                if (deploymentAnnotation != null) break block6;
                return null;
            }
        }
        if (deploymentAnnotation == null) {
            deploymentAnnotation = method.getAnnotation(Deployment.class);
        }
        if (deploymentAnnotation == null) {
            onMethod = false;
            for (Class<?> lookForAnnotationClass = testClass; lookForAnnotationClass != Object.class; lookForAnnotationClass = lookForAnnotationClass.getSuperclass()) {
                deploymentAnnotation = lookForAnnotationClass.getAnnotation(Deployment.class);
                if (deploymentAnnotation == null) continue;
                testClass = lookForAnnotationClass;
                break;
            }
        }
        if (deploymentAnnotation != null) {
            String[] resources = deploymentAnnotation.resources();
            LOG.debug("annotation @Deployment creates deployment for {}.{}", (Object)ClassNameUtil.getClassNameWithoutPackage(testClass), (Object)methodName);
            return TestHelper.annotationDeploymentSetUp(processEngine, resources, testClass, onMethod, methodName);
        }
        return null;
    }

    public static String annotationDeploymentSetUp(ProcessEngine processEngine, String[] resources, Class<?> testClass, String methodName) {
        return TestHelper.annotationDeploymentSetUp(processEngine, resources, testClass, true, methodName);
    }

    public static String annotationDeploymentSetUp(ProcessEngine processEngine, String[] resources, Class<?> testClass, boolean onMethod, String methodName) {
        if (resources != null) {
            if (resources.length == 0 && methodName != null) {
                String name = onMethod ? methodName : null;
                String resource = TestHelper.getBpmnProcessDefinitionResource(testClass, name);
                resources = new String[]{resource};
            }
            DeploymentBuilder deploymentBuilder = processEngine.getRepositoryService().createDeployment().name(ClassNameUtil.getClassNameWithoutPackage(testClass) + "." + methodName);
            for (String resource : resources) {
                deploymentBuilder.addClasspathResource(resource);
            }
            return deploymentBuilder.deploy().getId();
        }
        return null;
    }

    public static String annotationDeploymentSetUp(ProcessEngine processEngine, Class<?> testClass, String methodName, Class<?> ... parameterTypes) {
        return TestHelper.annotationDeploymentSetUp(processEngine, testClass, methodName, null, parameterTypes);
    }

    public static void annotationDeploymentTearDown(ProcessEngine processEngine, String deploymentId, Class<?> testClass, String methodName) {
        LOG.debug("annotation @Deployment deletes deployment for {}.{}", (Object)ClassNameUtil.getClassNameWithoutPackage(testClass), (Object)methodName);
        TestHelper.deleteDeployment(processEngine, deploymentId);
    }

    public static void deleteDeployment(ProcessEngine processEngine, String deploymentId) {
        if (deploymentId != null) {
            processEngine.getRepositoryService().deleteDeployment(deploymentId, true, true, true);
        }
    }

    public static String getBpmnProcessDefinitionResource(Class<?> type, String name) {
        for (String suffix : RESOURCE_SUFFIXES) {
            String resource = TestHelper.createResourceName(type, name, suffix);
            InputStream inputStream = ReflectUtil.getResourceAsStream(resource);
            if (inputStream == null) continue;
            return resource;
        }
        return TestHelper.createResourceName(type, name, BpmnDeployer.BPMN_RESOURCE_SUFFIXES[0]);
    }

    private static String createResourceName(Class<?> type, String name, String suffix) {
        StringBuilder r = new StringBuilder(type.getName().replace('.', '/'));
        if (name != null) {
            r.append(".").append(name);
        }
        return r.append(".").append(suffix).toString();
    }

    public static boolean annotationRequiredHistoryLevelCheck(ProcessEngine processEngine, RequiredHistoryLevel annotation, Class<?> testClass, String methodName) {
        if (annotation != null) {
            return TestHelper.historyLevelCheck(processEngine, annotation);
        }
        return TestHelper.annotationRequiredHistoryLevelCheck(processEngine, testClass, methodName, new Class[0]);
    }

    private static boolean historyLevelCheck(ProcessEngine processEngine, RequiredHistoryLevel annotation) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
        HistoryLevel requiredHistoryLevel = TestHelper.getHistoryLevelForName(processEngineConfiguration.getHistoryLevels(), annotation.value());
        HistoryLevel currentHistoryLevel = processEngineConfiguration.getHistoryLevel();
        return currentHistoryLevel.getId() >= requiredHistoryLevel.getId();
    }

    private static HistoryLevel getHistoryLevelForName(List<HistoryLevel> historyLevels, String name) {
        for (HistoryLevel historyLevel : historyLevels) {
            if (!historyLevel.getName().equalsIgnoreCase(name)) continue;
            return historyLevel;
        }
        throw new IllegalArgumentException("Unknown history level: " + name);
    }

    public static boolean annotationRequiredHistoryLevelCheck(ProcessEngine processEngine, Class<?> testClass, String methodName, Class<?> ... parameterTypes) {
        RequiredHistoryLevel annotation = TestHelper.getAnnotation(processEngine, testClass, methodName, RequiredHistoryLevel.class, parameterTypes);
        if (annotation != null) {
            return TestHelper.historyLevelCheck(processEngine, annotation);
        }
        return true;
    }

    public static boolean annotationRequiredDatabaseCheck(ProcessEngine processEngine, RequiredDatabase annotation, Class<?> testClass, String methodName, Class<?> ... parameterTypes) {
        if (annotation != null) {
            return TestHelper.databaseCheck(processEngine, annotation);
        }
        return TestHelper.annotationRequiredDatabaseCheck(processEngine, testClass, methodName, parameterTypes);
    }

    public static boolean annotationRequiredDatabaseCheck(ProcessEngine processEngine, Class<?> testClass, String methodName, Class<?> ... parameterTypes) {
        RequiredDatabase annotation = TestHelper.getAnnotation(processEngine, testClass, methodName, RequiredDatabase.class, parameterTypes);
        if (annotation != null) {
            return TestHelper.databaseCheck(processEngine, annotation);
        }
        return true;
    }

    private static boolean databaseCheck(ProcessEngine processEngine, RequiredDatabase annotation) {
        String[] includes;
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
        String actualDbType = processEngineConfiguration.getDbSqlSessionFactory().getDatabaseType();
        String[] excludes = annotation.excludes();
        if (excludes != null) {
            for (String exclude : excludes) {
                if (!exclude.equals(actualDbType)) continue;
                return false;
            }
        }
        if ((includes = annotation.includes()) != null && includes.length > 0) {
            for (String include : includes) {
                if (!include.equals(actualDbType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static <T extends Annotation> T getAnnotation(ProcessEngine processEngine, Class<?> testClass, String methodName, Class<T> annotationClass, Class<?> ... parameterTypes) {
        Method method = null;
        T annotation = null;
        try {
            method = TestHelper.getMethod(testClass, methodName, parameterTypes);
            annotation = method.getAnnotation(annotationClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (annotation == null) {
            annotation = testClass.getAnnotation(annotationClass);
        }
        return annotation;
    }

    protected static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            if (!clazz.equals(Object.class)) {
                return TestHelper.getMethod(clazz.getSuperclass(), methodName, parameterTypes);
            }
            throw e;
        }
    }

    public static void assertAndEnsureCleanDbAndCache(ProcessEngine processEngine) {
        TestHelper.assertAndEnsureCleanDbAndCache(processEngine, true);
    }

    public static String assertAndEnsureCleanDbAndCache(ProcessEngine processEngine, boolean fail) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        TestHelper.clearMetrics(processEngineConfiguration);
        TestHelper.clearUserOperationLog(processEngineConfiguration);
        LOG.debug("verifying that db is clean after test");
        PurgeReport purgeReport = ((ManagementServiceImpl)processEngine.getManagementService()).purge();
        String paRegistrationMessage = TestHelper.assertAndEnsureNoProcessApplicationsRegistered(processEngine);
        StringBuilder message = new StringBuilder();
        CachePurgeReport cachePurgeReport = purgeReport.getCachePurgeReport();
        if (!cachePurgeReport.isEmpty()) {
            message.append("Deployment cache is not clean:\n").append(cachePurgeReport.getPurgeReportAsString());
        } else {
            LOG.debug("Deployment cache was clean.");
        }
        DatabasePurgeReport databasePurgeReport = purgeReport.getDatabasePurgeReport();
        if (!databasePurgeReport.isEmpty()) {
            message.append("Database is not clean:\n").append(databasePurgeReport.getPurgeReportAsString());
        } else {
            LOG.debug("Database was clean.");
        }
        if (paRegistrationMessage != null) {
            message.append(paRegistrationMessage);
        }
        if (fail && message.length() > 0) {
            TestHelper.fail(message.toString());
        }
        return message.toString();
    }

    protected static void fail(String message) {
        if (message == null) {
            throw new AssertionError();
        }
        throw new AssertionError((Object)message);
    }

    public static void assertAndEnsureCleanDeploymentCache(ProcessEngine processEngine) {
        TestHelper.assertAndEnsureCleanDeploymentCache(processEngine, true);
    }

    public static String assertAndEnsureCleanDeploymentCache(ProcessEngine processEngine, boolean fail) {
        StringBuilder outputMessage = new StringBuilder();
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        CachePurgeReport cachePurgeReport = processEngineConfiguration.getDeploymentCache().purgeCache();
        outputMessage.append(cachePurgeReport.getPurgeReportAsString());
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "Deployment cache not clean:\n");
            LOG.error(outputMessage.toString());
            if (fail) {
                TestHelper.fail(outputMessage.toString());
            }
            return outputMessage.toString();
        }
        LOG.debug("Deployment cache was clean");
        return null;
    }

    public static String assertAndEnsureNoProcessApplicationsRegistered(ProcessEngine processEngine) {
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
        ProcessApplicationManager processApplicationManager = engineConfiguration.getProcessApplicationManager();
        if (processApplicationManager.hasRegistrations()) {
            processApplicationManager.clearRegistrations();
            return "There are still process applications registered";
        }
        return null;
    }

    public static void resetIdGenerator(ProcessEngineConfigurationImpl processEngineConfiguration) {
        IdGenerator idGenerator = processEngineConfiguration.getIdGenerator();
        if (idGenerator instanceof DbIdGenerator) {
            DbIdGenerator dbIdGenerator = (DbIdGenerator)idGenerator;
            dbIdGenerator.reset();
        }
    }

    public static ProcessEngine getProcessEngine(String configurationResource) {
        return TestHelper.getProcessEngine(configurationResource, null);
    }

    public static ProcessEngine getProcessEngine(String configurationResource, Consumer<ProcessEngineConfigurationImpl> processEngineConfigurator) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource(configurationResource);
        if (processEngineConfigurator != null) {
            processEngineConfigurator.accept(processEngineConfiguration);
        }
        if (ProcessEngines.isRegisteredProcessEngine(processEngineConfiguration.getProcessEngineName())) {
            return ProcessEngines.getProcessEngine(processEngineConfiguration.getProcessEngineName());
        }
        LOG.debug("==== BUILDING PROCESS ENGINE ========================================================================");
        ProcessEngine newProcessEngine = processEngineConfiguration.buildProcessEngine();
        LOG.debug("==== PROCESS ENGINE CREATED =========================================================================");
        return newProcessEngine;
    }

    public static void closeProcessEngines() {
        ProcessEngines.destroy();
    }

    public static void createSchema(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            commandContext.getSession(PersistenceSession.class).dbSchemaCreate();
            return null;
        });
    }

    public static void dropSchema(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            commandContext.getDbSqlSession().dbSchemaDrop();
            return null;
        });
    }

    public static void createOrUpdateHistoryLevel(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            DbEntityManager dbEntityManager = commandContext.getDbEntityManager();
            PropertyEntity historyLevelProperty = dbEntityManager.selectById(PropertyEntity.class, "historyLevel");
            if (historyLevelProperty != null) {
                if (processEngineConfiguration.getHistoryLevel().getId() != Integer.parseInt(historyLevelProperty.getValue())) {
                    historyLevelProperty.setValue(Integer.toString(processEngineConfiguration.getHistoryLevel().getId()));
                    dbEntityManager.merge(historyLevelProperty);
                }
            } else {
                HistoryLevelSetupCommand.dbCreateHistoryLevel(commandContext);
            }
            return null;
        });
    }

    public static void deleteHistoryLevel(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            DbEntityManager dbEntityManager = commandContext.getDbEntityManager();
            PropertyEntity historyLevelProperty = dbEntityManager.selectById(PropertyEntity.class, "historyLevel");
            if (historyLevelProperty != null) {
                dbEntityManager.delete(historyLevelProperty);
            }
            return null;
        });
    }

    public static void clearUserOperationLog(ProcessEngineConfigurationImpl processEngineConfiguration) {
        if (processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
            HistoryService historyService = processEngineConfiguration.getHistoryService();
            List logs = historyService.createUserOperationLogQuery().list();
            for (UserOperationLogEntry log : logs) {
                historyService.deleteUserOperationLogEntry(log.getId());
            }
        }
    }

    public static void clearMetrics(ProcessEngineConfigurationImpl processEngineConfiguration) {
        ManagementService managementService = processEngineConfiguration.getManagementService();
        managementService.deleteMetrics(null);
        managementService.deleteTaskMetrics(null);
    }

    public static void deleteInstallationId(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            DbEntityManager dbEntityManager = commandContext.getDbEntityManager();
            PropertyEntity installationIdProperty = dbEntityManager.selectById(PropertyEntity.class, "operaton.installation.id");
            if (installationIdProperty != null) {
                dbEntityManager.delete(installationIdProperty);
            }
            return null;
        });
    }

    public static Object defaultManualActivation() {
        FixedValue expression = new FixedValue(true);
        return new CaseControlRuleImpl(expression);
    }

    public static void executeJobIgnoringException(ManagementService managementService, String jobId) {
        try {
            managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void executeJobExpectingException(ManagementService managementService, String jobId) {
        Assertions.assertThatCode(() -> managementService.executeJob(jobId)).isInstanceOf(ProcessEngineException.class);
    }

    public static void executeJobExpectingException(ManagementService managementService, String jobId, String exceptionMessage) {
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> managementService.executeJob(jobId)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining(exceptionMessage);
    }

    public static void executeJobNotExpectingException(ManagementService managementService, String jobId) {
        Assertions.assertThatCode(() -> managementService.executeJob(jobId)).doesNotThrowAnyException();
    }

    static {
        RESOURCE_SUFFIXES.addAll(Arrays.asList(BpmnDeployer.BPMN_RESOURCE_SUFFIXES));
        RESOURCE_SUFFIXES.addAll(Arrays.asList(CmmnDeployer.CMMN_RESOURCE_SUFFIXES));
        RESOURCE_SUFFIXES.addAll(Arrays.asList(DecisionDefinitionDeployer.DMN_RESOURCE_SUFFIXES));
    }
}

