/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.repository;

import java.util.Date;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.cmd.ActivateProcessDefinitionCmd;
import org.operaton.bpm.engine.impl.cmd.CommandLogger;
import org.operaton.bpm.engine.impl.cmd.SuspendProcessDefinitionCmd;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.repository.UpdateProcessDefinitionSuspensionStateBuilder;
import org.operaton.bpm.engine.repository.UpdateProcessDefinitionSuspensionStateSelectBuilder;
import org.operaton.bpm.engine.repository.UpdateProcessDefinitionSuspensionStateTenantBuilder;

public class UpdateProcessDefinitionSuspensionStateBuilderImpl
implements UpdateProcessDefinitionSuspensionStateBuilder,
UpdateProcessDefinitionSuspensionStateSelectBuilder,
UpdateProcessDefinitionSuspensionStateTenantBuilder {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected final CommandExecutor commandExecutor;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected boolean includeProcessInstances;
    protected Date executionDate;
    protected String processDefinitionTenantId;
    protected boolean isTenantIdSet;

    public UpdateProcessDefinitionSuspensionStateBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public UpdateProcessDefinitionSuspensionStateBuilderImpl() {
        this(null);
    }

    @Override
    public UpdateProcessDefinitionSuspensionStateBuilderImpl byProcessDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull("processDefinitionId", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public UpdateProcessDefinitionSuspensionStateBuilderImpl byProcessDefinitionKey(String processDefinitionKey) {
        EnsureUtil.ensureNotNull("processDefinitionKey", (Object)processDefinitionKey);
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public UpdateProcessDefinitionSuspensionStateBuilderImpl includeProcessInstances(boolean includeProcessInstance) {
        this.includeProcessInstances = includeProcessInstance;
        return this;
    }

    @Override
    public UpdateProcessDefinitionSuspensionStateBuilderImpl executionDate(Date date) {
        this.executionDate = date;
        return this;
    }

    @Override
    public UpdateProcessDefinitionSuspensionStateBuilderImpl processDefinitionWithoutTenantId() {
        this.processDefinitionTenantId = null;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public UpdateProcessDefinitionSuspensionStateBuilderImpl processDefinitionTenantId(String tenantId) {
        EnsureUtil.ensureNotNull("tenantId", (Object)tenantId);
        this.processDefinitionTenantId = tenantId;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public void activate() {
        this.validateParameters();
        ActivateProcessDefinitionCmd command = new ActivateProcessDefinitionCmd(this);
        this.commandExecutor.execute(command);
    }

    @Override
    public void suspend() {
        this.validateParameters();
        SuspendProcessDefinitionCmd command = new SuspendProcessDefinitionCmd(this);
        this.commandExecutor.execute(command);
    }

    protected void validateParameters() {
        EnsureUtil.ensureOnlyOneNotNull("Need to specify either a process instance id or a process definition key.", this.processDefinitionId, this.processDefinitionKey);
        if (this.processDefinitionId != null && this.isTenantIdSet) {
            throw LOG.exceptionUpdateSuspensionStateForTenantOnlyByProcessDefinitionKey();
        }
        EnsureUtil.ensureNotNull("commandExecutor", (Object)this.commandExecutor);
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public boolean isIncludeProcessInstances() {
        return this.includeProcessInstances;
    }

    public Date getExecutionDate() {
        return this.executionDate;
    }

    public String getProcessDefinitionTenantId() {
        return this.processDefinitionTenantId;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }
}

