/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.pvm.runtime.operation;

import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.operaton.bpm.engine.impl.pvm.PvmException;
import org.operaton.bpm.engine.impl.pvm.PvmLogger;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.operaton.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;
import org.operaton.bpm.engine.impl.util.ActivityBehaviorUtil;

public class PvmAtomicOperationActivityLeave
implements PvmAtomicOperation {
    private static final PvmLogger LOG = ProcessEngineLogger.PVM_LOGGER;

    @Override
    public boolean isAsync(PvmExecutionImpl execution) {
        return false;
    }

    @Override
    public void execute(PvmExecutionImpl execution) {
        execution.activityInstanceDone();
        ActivityBehavior activityBehavior = ActivityBehaviorUtil.getActivityBehavior(execution);
        if (activityBehavior instanceof FlowNodeActivityBehavior) {
            FlowNodeActivityBehavior behavior = (FlowNodeActivityBehavior)activityBehavior;
            ActivityImpl activity = execution.getActivity();
            String activityInstanceId = execution.getActivityInstanceId();
            if (activityInstanceId != null) {
                LOG.debugLeavesActivityInstance(execution, activityInstanceId);
            }
            try {
                behavior.doLeave(execution);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PvmException("couldn't leave activity <" + String.valueOf(activity.getProperty("type")) + " id=\"" + activity.getId() + "\" ...>: " + e.getMessage(), e);
            }
        } else {
            throw new PvmException("Behavior of current activity is not an instance of " + FlowNodeActivityBehavior.class.getSimpleName() + ". Execution " + String.valueOf(execution));
        }
    }

    @Override
    public String getCanonicalName() {
        return "activity-leave";
    }

    @Override
    public boolean isAsyncCapable() {
        return false;
    }
}

