/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.operaton.bpm.engine.authorization.Authorization;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Permissions;
import org.operaton.bpm.engine.authorization.Resource;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.db.DbEntity;
import org.operaton.bpm.engine.impl.db.EnginePersistenceLogger;
import org.operaton.bpm.engine.impl.db.HasDbReferences;
import org.operaton.bpm.engine.impl.db.HasDbRevision;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.bpm.engine.impl.util.ResourceTypeUtil;

public class AuthorizationEntity
implements Authorization,
DbEntity,
HasDbRevision,
HasDbReferences,
Serializable {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected int authorizationType;
    protected int permissions;
    protected String userId;
    protected String groupId;
    protected Integer resourceType;
    protected String resourceId;
    protected Date removalTime;
    protected String rootProcessInstanceId;
    private Set<Permission> cachedPermissions = new HashSet<Permission>();

    public AuthorizationEntity() {
    }

    public AuthorizationEntity(int type) {
        this.authorizationType = type;
        if (this.authorizationType == 0) {
            this.userId = "*";
        }
        this.resetPermissions();
    }

    protected void resetPermissions() {
        this.cachedPermissions = new HashSet<Permission>();
        if (this.authorizationType == 0) {
            this.permissions = Permissions.NONE.getValue();
        } else if (this.authorizationType == 1) {
            this.permissions = Permissions.NONE.getValue();
        } else if (this.authorizationType == 2) {
            this.permissions = Permissions.ALL.getValue();
        } else {
            throw LOG.engineAuthorizationTypeException(this.authorizationType, 0, 1, 2);
        }
    }

    @Override
    public void addPermission(Permission p) {
        this.cachedPermissions.add(p);
        this.permissions |= p.getValue();
    }

    @Override
    public void removePermission(Permission p) {
        this.cachedPermissions.add(p);
        this.permissions &= ~p.getValue();
    }

    @Override
    public boolean isPermissionGranted(Permission p) {
        if (2 == this.authorizationType) {
            throw LOG.permissionStateException("isPermissionGranted", "REVOKE");
        }
        EnsureUtil.ensureNotNull("Authorization 'resourceType' cannot be null", "authorization.getResource()", (Object)this.resourceType);
        if (!ResourceTypeUtil.resourceIsContainedInArray(this.resourceType, p.getTypes())) {
            return false;
        }
        return (this.permissions & p.getValue()) == p.getValue();
    }

    @Override
    public boolean isPermissionRevoked(Permission p) {
        if (1 == this.authorizationType) {
            throw LOG.permissionStateException("isPermissionRevoked", "GRANT");
        }
        EnsureUtil.ensureNotNull("Authorization 'resourceType' cannot be null", "authorization.getResource()", (Object)this.resourceType);
        if (!ResourceTypeUtil.resourceIsContainedInArray(this.resourceType, p.getTypes())) {
            return false;
        }
        return (this.permissions & p.getValue()) != p.getValue();
    }

    @Override
    public boolean isEveryPermissionGranted() {
        if (2 == this.authorizationType) {
            throw LOG.permissionStateException("isEveryPermissionGranted", "REVOKE");
        }
        return this.permissions == Permissions.ALL.getValue();
    }

    @Override
    public boolean isEveryPermissionRevoked() {
        if (this.authorizationType == 1) {
            throw LOG.permissionStateException("isEveryPermissionRevoked", "GRANT");
        }
        return this.permissions == 0;
    }

    @Override
    public Permission[] getPermissions(Permission[] permissions) {
        ArrayList<Permission> result = new ArrayList<Permission>();
        for (Permission permission : permissions) {
            boolean revoked;
            boolean granted = (0 == this.authorizationType || 1 == this.authorizationType) && this.isPermissionGranted(permission);
            boolean bl = revoked = 2 == this.authorizationType && this.isPermissionRevoked(permission);
            if (!granted && !revoked) continue;
            result.add(permission);
        }
        return result.toArray(new Permission[result.size()]);
    }

    @Override
    public void setPermissions(Permission[] permissions) {
        this.resetPermissions();
        for (Permission permission : permissions) {
            if (2 == this.authorizationType) {
                this.removePermission(permission);
                continue;
            }
            this.addPermission(permission);
        }
    }

    @Override
    public int getAuthorizationType() {
        return this.authorizationType;
    }

    public void setAuthorizationType(int authorizationType) {
        this.authorizationType = authorizationType;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void setGroupId(String groupId) {
        if (groupId != null && this.authorizationType == 0) {
            throw LOG.notUsableGroupIdForGlobalAuthorizationException();
        }
        this.groupId = groupId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setUserId(String userId) {
        if (userId != null && this.authorizationType == 0 && !"*".equals(userId)) {
            throw LOG.illegalValueForUserIdException(userId, "*");
        }
        this.userId = userId;
    }

    @Override
    public int getResourceType() {
        return this.resourceType;
    }

    @Override
    public void setResourceType(int type) {
        this.resourceType = type;
    }

    public Integer getResource() {
        return this.resourceType;
    }

    @Override
    public void setResource(Resource resource) {
        this.resourceType = resource.resourceType();
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    public void setPermissions(int permissions) {
        this.permissions = permissions;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public Set<Permission> getCachedPermissions() {
        return this.cachedPermissions;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("userId", this.userId);
        state.put("groupId", this.groupId);
        state.put("resourceType", this.resourceType);
        state.put("resourceId", this.resourceId);
        state.put("permissions", this.permissions);
        state.put("removalTime", this.removalTime);
        state.put("rootProcessInstanceId", this.rootProcessInstanceId);
        return state;
    }

    @Override
    public Date getRemovalTime() {
        return this.removalTime;
    }

    public void setRemovalTime(Date removalTime) {
        this.removalTime = removalTime;
    }

    @Override
    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    @Override
    public Set<String> getReferencedEntityIds() {
        return new HashSet<String>();
    }

    @Override
    public Map<String, Class> getReferencedEntitiesIdAndClass() {
        return new HashMap<String, Class>();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", revision=" + this.revision + ", authorizationType=" + this.authorizationType + ", permissions=" + this.permissions + ", userId=" + this.userId + ", groupId=" + this.groupId + ", resourceType=" + this.resourceType + ", resourceId=" + this.resourceId + "]";
    }
}

