/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.migration.validation.instruction;

import java.util.List;
import org.operaton.bpm.engine.impl.bpmn.behavior.InclusiveGatewayActivityBehavior;
import org.operaton.bpm.engine.impl.bpmn.behavior.ParallelGatewayActivityBehavior;
import org.operaton.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import org.operaton.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import org.operaton.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import org.operaton.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import org.operaton.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.operaton.bpm.engine.impl.pvm.process.ActivityImpl;
import org.operaton.bpm.engine.impl.pvm.process.ScopeImpl;

public class GatewayMappingValidator
implements MigrationInstructionValidator {
    @Override
    public void validate(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        ActivityImpl targetActivity = instruction.getTargetActivity();
        if (this.isWaitStateGateway(targetActivity)) {
            this.validateIncomingSequenceFlows(instruction, instructions, report);
            this.validateParentScopeMigrates(instruction, instructions, report);
            this.validateSingleInstruction(instruction, instructions, report);
        }
    }

    protected void validateIncomingSequenceFlows(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        int numTargetIncomingFlows;
        ActivityImpl sourceActivity = instruction.getSourceActivity();
        ActivityImpl targetActivity = instruction.getTargetActivity();
        int numSourceIncomingFlows = sourceActivity.getIncomingTransitions().size();
        if (numSourceIncomingFlows > (numTargetIncomingFlows = targetActivity.getIncomingTransitions().size())) {
            report.addFailure("The target gateway must have at least the same number of incoming sequence flows that the source gateway has");
        }
    }

    protected void validateParentScopeMigrates(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        ActivityImpl sourceActivity = instruction.getSourceActivity();
        ScopeImpl flowScope = sourceActivity.getFlowScope();
        if (flowScope != flowScope.getProcessDefinition() && instructions.getInstructionsBySourceScope(flowScope).isEmpty()) {
            report.addFailure("The gateway's flow scope '" + flowScope.getId() + "' must be mapped");
        }
    }

    protected void validateSingleInstruction(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        ActivityImpl targetActivity = instruction.getTargetActivity();
        List<ValidatingMigrationInstruction> instructionsToTargetGateway = instructions.getInstructionsByTargetScope(targetActivity);
        if (instructionsToTargetGateway.size() > 1) {
            report.addFailure("Only one gateway can be mapped to gateway '" + targetActivity.getId() + "'");
        }
    }

    protected boolean isWaitStateGateway(ActivityImpl activity) {
        ActivityBehavior behavior = activity.getActivityBehavior();
        return behavior instanceof ParallelGatewayActivityBehavior || behavior instanceof InclusiveGatewayActivityBehavior;
    }
}

