/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.json;

import java.util.ArrayList;
import java.util.List;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.Direction;
import org.operaton.bpm.engine.impl.QueryOrderingProperty;
import org.operaton.bpm.engine.impl.QueryPropertyImpl;

public class JsonLegacyQueryOrderingPropertyConverter {
    public static final String ORDER_BY_DELIMITER = ",";
    public static final JsonLegacyQueryOrderingPropertyConverter INSTANCE = new JsonLegacyQueryOrderingPropertyConverter();

    public List<QueryOrderingProperty> fromOrderByString(String orderByString) {
        String[] orderByClauses;
        ArrayList<QueryOrderingProperty> properties = new ArrayList<QueryOrderingProperty>();
        for (String orderByClause : orderByClauses = orderByString.split(ORDER_BY_DELIMITER)) {
            String[] clauseParts = (orderByClause = orderByClause.trim()).split(" ");
            if (clauseParts.length == 0) continue;
            if (clauseParts.length > 2) {
                throw new ProcessEngineException("Invalid order by clause: " + orderByClause);
            }
            String function = null;
            String propertyPart = clauseParts[0];
            int functionArgumentBegin = propertyPart.indexOf("(");
            if (functionArgumentBegin >= 0) {
                function = propertyPart.substring(0, functionArgumentBegin);
                int functionArgumentEnd = propertyPart.indexOf(")");
                propertyPart = propertyPart.substring(functionArgumentBegin + 1, functionArgumentEnd);
            }
            String[] propertyParts = propertyPart.split("\\.");
            String property = null;
            if (propertyParts.length == 1) {
                property = propertyParts[0];
            } else if (propertyParts.length == 2) {
                property = propertyParts[1];
            } else {
                throw new ProcessEngineException("Invalid order by property part: " + clauseParts[0]);
            }
            QueryPropertyImpl queryProperty = new QueryPropertyImpl(property, function);
            Direction direction = null;
            if (clauseParts.length == 2) {
                String directionPart = clauseParts[1];
                direction = Direction.findByName(directionPart);
            }
            QueryOrderingProperty orderingProperty = new QueryOrderingProperty(null, queryProperty);
            orderingProperty.setDirection(direction);
            properties.add(orderingProperty);
        }
        return properties;
    }
}

