/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.dmn.transformer;

import org.operaton.bpm.dmn.engine.impl.DmnDecisionImpl;
import org.operaton.bpm.dmn.engine.impl.spi.transform.DmnElementTransformContext;
import org.operaton.bpm.dmn.engine.impl.transform.DmnDecisionTransformHandler;
import org.operaton.bpm.engine.impl.HistoryTimeToLiveParser;
import org.operaton.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.operaton.bpm.model.dmn.instance.Decision;

public class DecisionDefinitionHandler
extends DmnDecisionTransformHandler {
    protected boolean skipEnforceTtl;

    protected DmnDecisionImpl createDmnElement() {
        return new DecisionDefinitionEntity();
    }

    protected DmnDecisionImpl createFromDecision(DmnElementTransformContext context, Decision decision) {
        DecisionDefinitionEntity decisionDefinition = (DecisionDefinitionEntity)super.createFromDecision(context, decision);
        String category = context.getModelInstance().getDefinitions().getNamespace();
        decisionDefinition.setCategory(category);
        decisionDefinition.setVersionTag(decision.getVersionTag());
        this.validateAndSetHTTL(decision, decisionDefinition, this.isSkipEnforceTtl());
        return decisionDefinition;
    }

    protected void validateAndSetHTTL(Decision decision, DecisionDefinitionEntity decisionDefinition, boolean skipEnforceTtl) {
        Integer historyTimeToLive = HistoryTimeToLiveParser.create().parse(decision, decisionDefinition.getKey(), skipEnforceTtl);
        decisionDefinition.setHistoryTimeToLive(historyTimeToLive);
    }

    public boolean isSkipEnforceTtl() {
        return this.skipEnforceTtl;
    }

    public void setSkipEnforceTtl(boolean skipEnforceTtl) {
        this.skipEnforceTtl = skipEnforceTtl;
    }
}

