/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.digest;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.Random;
import org.operaton.bpm.engine.impl.digest.SaltGenerator;

public abstract class Base64EncodedSaltGenerator
implements SaltGenerator {
    protected Random secureRandom = new SecureRandom();

    @Override
    public String generateSalt() {
        byte[] byteSalt = this.generateByteSalt();
        return this.encodeSalt(byteSalt);
    }

    protected byte[] generateByteSalt() {
        byte[] salt = new byte[this.getSaltLengthInByte().intValue()];
        this.secureRandom.nextBytes(salt);
        return salt;
    }

    protected String encodeSalt(byte[] salt) {
        return Base64.getEncoder().encodeToString(salt);
    }

    protected abstract Integer getSaltLengthInByte();
}

