/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmmn.listener;

import java.util.List;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.delegate.CaseExecutionListener;
import org.operaton.bpm.engine.delegate.DelegateCaseExecution;
import org.operaton.bpm.engine.delegate.Expression;
import org.operaton.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.operaton.bpm.engine.impl.cmmn.delegate.CaseExecutionListenerInvocation;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.util.ClassDelegateUtil;

public class DelegateExpressionCaseExecutionListener
implements CaseExecutionListener {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionCaseExecutionListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void notify(DelegateCaseExecution caseExecution) throws Exception {
        Object delegate = this.expression.getValue(caseExecution);
        ClassDelegateUtil.applyFieldDeclaration(this.fieldDeclarations, delegate);
        if (!(delegate instanceof CaseExecutionListener)) {
            throw new ProcessEngineException("Delegate expression " + String.valueOf(this.expression) + " did not resolve to an implementation of " + String.valueOf(CaseExecutionListener.class));
        }
        CaseExecutionListener listenerInstance = (CaseExecutionListener)delegate;
        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new CaseExecutionListenerInvocation(listenerInstance, caseExecution));
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }

    public List<FieldDeclaration> getFieldDeclarations() {
        return this.fieldDeclarations;
    }
}

