/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class RegisterDeploymentCmd
implements Command<Void> {
    protected String deploymentId;

    public RegisterDeploymentCmd(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        DeploymentEntity deployment = commandContext.getDeploymentManager().findDeploymentById(this.deploymentId);
        EnsureUtil.ensureNotNull("Deployment " + this.deploymentId + " does not exist", "deployment", (Object)deployment);
        commandContext.getAuthorizationManager().checkOperatonAdminOrPermission(CommandChecker::checkRegisterDeployment);
        Context.getProcessEngineConfiguration().getRegisteredDeployments().add(this.deploymentId);
        return null;
    }
}

