/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.Collections;
import java.util.List;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.operaton.bpm.engine.impl.cfg.CommandChecker;
import org.operaton.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.operaton.bpm.engine.impl.cmd.ActivityCancellationCmd;
import org.operaton.bpm.engine.impl.cmd.CommandLogger;
import org.operaton.bpm.engine.impl.cmd.GetActivityInstanceCmd;
import org.operaton.bpm.engine.impl.interceptor.Command;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.operaton.bpm.engine.impl.persistence.entity.PropertyChange;
import org.operaton.bpm.engine.impl.util.ModificationUtil;
import org.operaton.bpm.engine.runtime.ActivityInstance;

public class ModifyProcessInstanceCmd
implements Command<Void> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected ProcessInstanceModificationBuilderImpl builder;
    protected boolean writeOperationLog;

    public ModifyProcessInstanceCmd(ProcessInstanceModificationBuilderImpl processInstanceModificationBuilder) {
        this(processInstanceModificationBuilder, true);
    }

    public ModifyProcessInstanceCmd(ProcessInstanceModificationBuilderImpl processInstanceModificationBuilder, boolean writeOperationLog) {
        this.builder = processInstanceModificationBuilder;
        this.writeOperationLog = writeOperationLog;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        String processInstanceId = this.builder.getProcessInstanceId();
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity processInstance = executionManager.findExecutionById(processInstanceId);
        this.ensureProcessInstanceExist(processInstanceId, processInstance);
        this.checkUpdateProcessInstance(processInstance, commandContext);
        processInstance.setPreserveScope(true);
        List<AbstractProcessInstanceModificationCommand> instructions = this.builder.getModificationOperations();
        this.checkCancellation(commandContext);
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractProcessInstanceModificationCommand instruction = instructions.get(i);
            LOG.debugModificationInstruction(processInstanceId, i + 1, instruction.describe());
            instruction.setSkipCustomListeners(this.builder.isSkipCustomListeners());
            instruction.setSkipIoMappings(this.builder.isSkipIoMappings());
            instruction.setExternallyTerminated(this.builder.isExternallyTerminated());
            instruction.execute(commandContext);
        }
        processInstance = executionManager.findExecutionById(processInstanceId);
        if (!(processInstance.hasChildren() || processInstance.isCanceled() || processInstance.isRemoved())) {
            if (processInstance.getActivity() == null) {
                this.checkDeleteProcessInstance(processInstance, commandContext);
                this.deletePropagate(processInstance, this.builder.getModificationReason(), this.builder.isSkipCustomListeners(), this.builder.isSkipIoMappings(), this.builder.isExternallyTerminated());
            } else if (processInstance.isEnded()) {
                processInstance.propagateEnd();
            }
        }
        if (this.writeOperationLog) {
            commandContext.getOperationLogManager().logProcessInstanceOperation(this.getLogEntryOperation(), processInstanceId, null, null, Collections.singletonList(PropertyChange.EMPTY_CHANGE), this.builder.getAnnotation());
        }
        return null;
    }

    private void checkCancellation(CommandContext commandContext) {
        for (AbstractProcessInstanceModificationCommand instruction : this.builder.getModificationOperations()) {
            if (!(instruction instanceof ActivityCancellationCmd)) continue;
            ActivityCancellationCmd cmd = (ActivityCancellationCmd)instruction;
            if (!cmd.cancelCurrentActiveActivityInstances) continue;
            ActivityInstance activityInstanceTree = commandContext.runWithoutAuthorization(new GetActivityInstanceCmd(cmd.processInstanceId));
            cmd.setActivityInstanceTreeToCancel(activityInstanceTree);
        }
    }

    protected void ensureProcessInstanceExist(String processInstanceId, ExecutionEntity processInstance) {
        if (processInstance == null) {
            throw LOG.processInstanceDoesNotExist(processInstanceId);
        }
    }

    protected String getLogEntryOperation() {
        return "ModifyProcessInstance";
    }

    protected void checkUpdateProcessInstance(ExecutionEntity execution, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessInstance(execution);
        }
    }

    protected void checkDeleteProcessInstance(ExecutionEntity execution, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteProcessInstance(execution);
        }
    }

    protected void deletePropagate(ExecutionEntity processInstance, String deleteReason, boolean skipCustomListeners, boolean skipIoMappings, boolean externallyTerminated) {
        ExecutionEntity topmostDeletableExecution = processInstance;
        ExecutionEntity parentScopeExecution = (ExecutionEntity)topmostDeletableExecution.getParentScopeExecution(true);
        while (parentScopeExecution != null && parentScopeExecution.getNonEventScopeExecutions().size() <= 1) {
            topmostDeletableExecution = parentScopeExecution;
            parentScopeExecution = (ExecutionEntity)topmostDeletableExecution.getParentScopeExecution(true);
        }
        topmostDeletableExecution.deleteCascade(deleteReason, skipCustomListeners, skipIoMappings, externallyTerminated, false);
        ModificationUtil.handleChildRemovalInScope(topmostDeletableExecution);
    }
}

