/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl.cmd;

import java.util.Map;
import org.operaton.bpm.engine.impl.cmd.HandleExternalTaskCmd;
import org.operaton.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class HandleExternalTaskFailureCmd
extends HandleExternalTaskCmd {
    protected String errorMessage;
    protected String errorDetails;
    protected long retryDuration;
    protected int retries;
    protected Map<String, Object> variables;
    protected Map<String, Object> localVariables;

    public HandleExternalTaskFailureCmd(String externalTaskId, String workerId, String errorMessage, String errorDetails, int retries, long retryDuration, Map<String, Object> variables, Map<String, Object> localVariables) {
        super(externalTaskId, workerId);
        this.errorMessage = errorMessage;
        this.errorDetails = errorDetails;
        this.retries = retries;
        this.retryDuration = retryDuration;
        this.variables = variables;
        this.localVariables = localVariables;
    }

    @Override
    public void execute(ExternalTaskEntity externalTask) {
        externalTask.failed(this.errorMessage, this.errorDetails, this.retries, this.retryDuration, this.variables, this.localVariables);
    }

    @Override
    protected void validateInput() {
        super.validateInput();
        EnsureUtil.ensureGreaterThanOrEqual("retries", this.retries, 0L);
        EnsureUtil.ensureGreaterThanOrEqual("retryDuration", this.retryDuration, 0L);
    }

    @Override
    public String getErrorMessageOnWrongWorkerAccess() {
        return "Failure of External Task " + this.externalTaskId + " cannot be reported by worker '" + this.workerId;
    }
}

